<?php

namespace IZON\Admin\Domain;

use \IZON\DB\DBObject;
use IZON\Admin\Domain\AdminRole;

/**
 * nejaka ztavba na kterou se ma odkazovar
 */
class AdminUser implements DBObject {
    
    /**
     * nazev tabulky na kterou se mapuje
     */
    public static function __tableName() { return 'core_admin_users'; }
    
    /**
     * @var integer 
     */
    protected $id;

    /**
     * @var string
     */
    protected $firstName;

    /**
     * @var string
     */
    protected $lastName;
    
    /**
     * @var string 
     */
    protected $login;
    
    /**
     * @var string 
     */
    protected $password;

    /**
     * Jestli se aktivni
     * @var boolean
     */
    protected $active;
    
    /**
     * jestli je superuzivatel tj. ma pristup vsude a ke vsemu
     * @var boolean
     */
    protected $superuser;
    
    /**
     * @var integer jakou zemi ma mit uzivatel predvibranou pro spravu
     */
    protected $fkCountryId;
    
    /**
     * @var integer jakou rec si uzivatel vyplnil pro spravu
     */
    protected $fkLanguageId;
    
    /**
     * @var integer jakym locale se ma uzivateli zobrazovat rozhrani admina
     */
    protected $fkInterfaceLocaleId;
    
    /**
     * @var AdminRole[] 
     */
    protected $roles = [];
    public static function __roles() { return \IZON\DB\transientField(); }


/// generovane gettery a settery 
    function getId() {
        return $this->id;
    }

    function getFirstName() {
        return $this->firstName;
    }

    function getLastName() {
        return $this->lastName;
    }

    function getLogin() {
        return $this->login;
    }

    function getPassword() {
        return $this->password;
    }

    function getActive() {
        return $this->active;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setFirstName($firstName) {
        $this->firstName = $firstName;
    }

    function setLastName($lastName) {
        $this->lastName = $lastName;
    }

    function setLogin($login) {
        $this->login = $login;
    }

    function setPassword($password) {
        $this->password = $password;
    }

    function setActive($active) {
        $this->active = $active;
    }

    function getSuperuser() {
        return $this->superuser;
    }

    function setSuperuser($superuser) {
        $this->superuser = $superuser;
    }
    
    function getFkCountryId() {
        return $this->fkCountryId;
    }

    function setFkCountryId($fkCountryId) {
        $this->fkCountryId = $fkCountryId;
    }
    
    function getFkLanguageId() {
        return $this->fkLanguageId;
    }

    function setFkLanguageId($fkLanguageId) {
        $this->fkLanguageId = $fkLanguageId;
    }
    
    public function getRoles() {
      return $this->roles;
    }

    public function setRoles(array $roles) {
        $this->roles = [];
        foreach($roles as $role) {
            $this->roles[$role->getId()] = $role;
        }
    }
    
    public function addRole(AdminRole $role) {
      $this->roles[$role->getId()] = $role; 
    }
    /**
     * overi, jestli ma prihlazeny uzivatel zadanou roli
     * pro sureusera vzdy vraci true
     * 
     * @param Role $role
     * @return boolean
     */
    public function hasRoleByRole(AdminRole $role) {
      if($this->superuser) {
          return true;
      }
      
      return array_key_exists($role->getId(), $this->roles);
    }
    
    /**
     * overi, jestli ma prihlazeny uzivatel zadanou roli
     * pro sureusera vzdy vraci true
     * 
     * @param [int|array] $roleId
     * @return boolean
     */
    public function hasRoleByRoleId($roleId) {
        if ($this->superuser) {
            return true;
        }

        if (!empty($roleId) && is_array($roleId)) {
            foreach ($roleId as $key => $value) {
                if (array_key_exists($value, $this->roles)) {
                    return true;
                }
            }
        } else {
            return array_key_exists($roleId, $this->roles);
        }
    }
    
/// generated getters and setters
    function getFkInterfaceLocaleId() {
        return $this->fkInterfaceLocaleId;
    }

    function setFkInterfaceLocaleId($fkInterfaceLocaleId) {
        $this->fkInterfaceLocaleId = $fkInterfaceLocaleId;
    }


}
