<?php

namespace IZON\Admin\Services;

use IZON\DBLocale\Domain\Country;
use IZON\DBLocale\Domain\Locale;

use \IZON\Admin\Domain\AdminUser;
use IZON\Admin\Presentation\Domain\AdminModuleInfo;


/**
 * Servis slouzici k udrzovani iiformaci o prihlasenem uzivateli a
 * k prihlaseni a odhlaseni uzivatele
 */
interface SessionService {
    
    /**
     * prihlasi uzivatele nebo vyhodi vyjimu proc to neni mozne
     * @param string $login
     * @param string $password
     */
    public function loginUser($login, $password);
    
    /**
     * odhlasi v soucasnosti prihlaseneho uzivatele
     */
    public function logoutUser();
    
    /**
     * vraci true pokud je do aplikace prihlsen uzivatel
     * @return boolean
     */
    public function isUserLoggedIn();
    
    /**
     * @return AdminUser currently logged user
     * @throws Exception if user isn't logged in
     */
    public function getLoggedUser();
    
    /**
     * returns information about modules accessable to currently logged user
     * @return AdminModuleInfo 
     */
    function getLoggedUserModules();

    /**
     * @return Country[] countries that user can access
     */
    function getUserCountries();
    
    /**
     * vraci prave vybranou zemi pro kterou se provadi editace
     * @return Country 
     */
    public function getSelectedCountry();
    
    /**
     * nastavuje prave vybranou zemi
     */
    public function setSelectedCountry($countryCode);
    
    /**
     * returns all supported locales for interface of admin
     * @return Locale[] Description 
     */
    function getSupportedInterfaceLocales();
    
    /**
     * returns currently selected locale for admin interface
     * @return Locale 
     */
    public function getSelectedInterfaceLocale();
    
    /**
     * nastavuje prave vybranou zemi
     * @param string $localeTag locale tag to set
     */
    public function setSelectedInterfaceLocale($localeTag);
    
    /**
     * sets locale for loged user
     */
    public function setLoggedUserInterfaceLocale();

        /**
     * vypocita hash hesla podle kterehose potom da vypocitat
     * @param string $password
     */
    public function computePasswordHash($password);
}
