<?php
$locale = \PHPView\getLocale();
?>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- FontAwesome -->
<script defer src="https://use.fontawesome.com/releases/v5.0.9/js/all.js" integrity="sha384-8iPTk2s/jMVj81dnzb/iFR2sdA7u06vHJyyLlAd4snFpCl/SnyUjRrbdJsw1pGIl" crossorigin="anonymous"></script>

<?php
$moduleInfo = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
$moduleName = __('Nástěnka - Administrace');
if($moduleInfo) {
    $moduleName = $moduleInfo->getName() . __(' - Administrace');
}
?>
<title><?= $moduleName ?></title>

<?php

/// CSS SECTION
// common styles
$commonCss = [
    '/admin/default/static/css/style.css',
];
PHPView\includeStyles($commonCss);
PHPView\insertScripts([['external' => true, 'src' => '//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&amp;subset=latin,latin-ext']], 'css');

// handles autoloads styles
$autoloadStyles = AdminPHPView\getStylesAutoloadURLs();
foreach($autoloadStyles as $style) {
    PHPView\includeStyles([$style["url"]]);
}
  
/// JS SECTION
// common scripts
$commonJs = [
    '/admin/default/static/js/app.js'
];
PHPView\includeScripts($commonJs);

// handles autoload scripts
$autoloadScripts = AdminPHPView\getScriptsAutoloadURLs();
foreach($autoloadScripts as $script) {
    PHPView\includeScripts([$script["url"]]);
}

?>
<script type="text/javascript">
var generalParams = {
    'locale': '<?= $locale->toLocaleTag() ?>',
    'language': '<?= $locale->getLanguage() ?>',
    'country': '<?= $locale->getCountry() ?>',
    
    'fileUploadMaxSize': <?= \PHPView\getParameter("fileUploadMaxSize") ?>, // upload velikost souboru v MB
    'fileUploadMaxSizeB': <?= \PHPView\getParameter("fileUploadMaxSizeB") ?> // upload velikost souboru v B
};

var getNotificationsURL = "<?= \PHPView\getControllerURL("izon.admin.controller.notificationsController", [], "ajaxGetNotificationsJson") ?>";    
//var getNotificationsDelay=10000; // 10 second    
var getNotificationsDelay=120000; // 2 minuty    

// udrzuje admin session otevrenou, pozdeji by melo natahovat nejaka upzorneni
function getNotifications() {
    $.get(getNotificationsURL, function( data ) {
        // zpracovani upozorneni
        
        // spustit dalsi
        setTimeout(getNotifications, getNotificationsDelay);
    });
}

getNotifications();
</script>


<?php
echo adminLoadModuleScripts();
