<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\MVC\Interceptors\Interceptor;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

use IZON\Admin\Services\SessionService;

/**
 * zpristupni prihlaseneho uzivatele pro view
 */
class SupportedCountriesInterceptor implements Interceptor {
    
    /**
     * @var SessionService 
     */
    protected $sessionService;

    /**
     * pod jakym jemnem se ma zpristupnit ve view
     * @var string
     */
    protected $supportedCountriesModelName = "adminSupportedCountries";
    
    
    public function __construct(SessionService $sessionService) {
        $this->sessionService = $sessionService;
    }
    
    public function afterCompletion(HttpRequest $request, $exception) {
        
    }

    public function postHandle(HttpRequest $request, ModelAndView $model) {
        $countries = $this->sessionService->getUserCountries();
        $model->putParameter($this->supportedCountriesModelName, $countries);  
        return $model;
    }

    public function preHandle(HttpRequest $request) {
        
    }

}
