<?php

namespace IZON\Admin\Web\Controllers;

use Exception;

use \IZON\Admin\Services\SessionService;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * switches to selected locale
 */
class SwitchInterfaceLocaleController implements Controller {
    
    /**
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * @var string|null na ktery controller se ma presmerovat po znene nastaveni zeme
     */
    protected $redirectCotrollerIdentifier = NULL;

    /**
     * @var string 
     */
    protected $localeTagParamName = "localeTag";


    public function __construct(SessionService $sessionService,
                                $redirectCotrollerIdentifier) {
        $this->sessionService = $sessionService;
        $this->redirectCotrollerIdentifier = $redirectCotrollerIdentifier;
    }
    
    public function execute(HttpRequest $request) {
        if( !$request->hasParameter($this->localeTagParamName) ) {
            throw new Exception("Neobsahuje parametr countryCode pro změnu jazyka");
        }
        
        $localeTag = $request->getParameter($this->localeTagParamName);
        $this->sessionService->setSelectedInterfaceLocale($localeTag);
        
        $modelAndView = ModelAndView::createControllerRedirect($this->redirectCotrollerIdentifier, []);
        return $modelAndView;
    }
}
