<!-- Sidebar -->
<?php
    $activeModule = \PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
    /* @var $loggedUserModules \IZON\Admin\Presentation\Domain\AdminModuleInfo[] */
    $loggedUserModules = \PHPView\getParameter("loggedUserModules");
?>
<nav class="nav">
    <ul>
        <li>
            <a href="<?= \PHPView\getControllerURL("izon.admin.controller.dashboardController") ?>" class="nav__link icon--desktop<?= $activeModule == NULL ? " active" : "" ?>"><?= __('Nástěnka') ?></a>
        </li>
        <?php
            foreach($loggedUserModules as $moduleId => $moduleInfo) {
                $defaultAction = $moduleInfo->getDefaultAction();
                
                $moduleURL = AdminPHPView\getModuleActionURL($defaultAction->getControllerIdentifier(),
                                                                $defaultAction->getMethodName(),
                                                                $defaultAction->getParameters(),
                                                                $moduleInfo->getIdentifier());
                $icon = $moduleInfo->getIcon();
                if( $icon == NULL) {
                    $icon = "list";
                }
            ?>
                <li<?= ($icon=='superuser'?' class="nav__item--superuser"':'') ?>>
                    <a href="<?= $moduleURL ?>" class="nav__link icon--<?= $icon . ($moduleInfo->isCurrentModule() ? " active" : "") ?>"><?= $moduleInfo->getModuleName() ?></a>
                    <?php
                    if( $moduleInfo->isCurrentModule() ) {
                        $menuActions = $moduleInfo->getModuleMenuActions();
                        echo '<ul class="nav__subnav">';
                        foreach($menuActions as $menuAction) {
                            $moduleURL = AdminPHPView\getModuleActionURL($menuAction->getControllerIdentifier(),
                                                                        $menuAction->getMethodName(),
                                                                        $menuAction->getParameters(),
                                                                        $moduleInfo->getIdentifier());
                            
                            $activeclass = '';
                            if( $menuAction->isCurrentAction() || $menuAction->isParentAction() ) {
                                $activeclass = ' active';
                            }
                            ?>
                            <li><a href="<?= $moduleURL ?>" class="nav__link<?=$activeclass?>"><?= $menuAction->getName() ?></a></li>
                            <?php
                        }
                        echo '</ul>';
                    }
                    ?>
                </li>
            <?php
            }
        ?>
    </ul>
</nav>
<!-- /sidebar -->