<?php

use IZON\DB\QueryHelpers;

use IZON\Admin\Domain\AdminRoleModule;
use IZON\Admin\Domain\AdminUserRole;

return [
    /**
     * Vraci vsechny aktivni moduly
     * @param QueryHelpers
     */
    "findActiveModules_0" => [
        'cacheResult' => false,
        'queryFactory' => function(QueryHelpers $queryHelpers) {
            return 'select '. $queryHelpers->getClassProperties("m")  
                .' from '. $queryHelpers->getTableName("m") 
                .' where '. $queryHelpers->getCoumnName("enabled") .' = 1 '
                .' order by '. $queryHelpers->getCoumnName("moduleOrder") ." asc "
                ." limit :maxResults offset :firstResult";
        },
    ],
    
    /**
     * Vraci vsechny viditelne moduly v adminu
     * @param QueryHelpers
     */
    "findAdminVisibleModules_0" => [
        'queryFactory' => function (QueryHelpers $queryHelpers) {
            return 'select '. $queryHelpers->getClassProperties("m")  
                .' from '. $queryHelpers->getTableName("m") 
                .' where '. $queryHelpers->getCoumnName("enabled") .' = 1 '
                    .' and '. $queryHelpers->getCoumnName("adminVisible") .' = 1 '
                .' order by '. $queryHelpers->getCoumnName("moduleOrder") ." asc "
                ." limit :maxResults offset :firstResult";
        }
    ],
    
    "findUserAdminVisibleModules_1" => [
        'queryFactory' => function(QueryHelpers $queryHelpers) {
            $query = 'select distinct '. $queryHelpers->getClassProperties("m")  
                .' from '. $queryHelpers->getTableName("m") 
                    .' join '. $queryHelpers->getClassTableName(AdminRoleModule::class, "agm")  
                        .' on '. $queryHelpers->getCoumnName("id", "m") 
                            ." = ". $queryHelpers->getClassCoumnName(AdminRoleModule::class, 'fkAdminModuleId', "agm")
                    .' join '. $queryHelpers->getClassTableName(AdminUserRole::class, "aug")  
                        .' on '. $queryHelpers->getClassCoumnName(AdminUserRole::class, 'fkAdminRoleId', "aug")
                            ." = ". $queryHelpers->getClassCoumnName(AdminRoleModule::class, 'fkAdminRoleId', "agm")
                .' where '. $queryHelpers->getCoumnName("enabled") .' = 1 '
                    .' and '. $queryHelpers->getCoumnName("adminVisible") .' = 1 '
                    .' and '. $queryHelpers->getClassCoumnName(AdminUserRole::class, 'fkAdminUserId', "aug") .' = '. $queryHelpers->getParameterName(0)
                .' order by '. $queryHelpers->getCoumnName("moduleOrder") ." asc limit :maxResults offset :firstResult";
//        var_dump($query);
            return $query;
        }
    ],
            
    "findRoleModules_1" => [
        'queryFactory' => function(QueryHelpers $queryHelpers) {
            $query = 'select distinct '. $queryHelpers->getClassProperties("m")  
                    .' from '. $queryHelpers->getTableName("m") 
                        .' join '. $queryHelpers->getClassTableName(AdminRoleModule::class, "agm")  
                            .' on '. $queryHelpers->getCoumnName("id", "m") 
                                ." = ". $queryHelpers->getClassCoumnName(AdminRoleModule::class, 'fkAdminModuleId', "agm")
                    .' where '.  $queryHelpers->getClassCoumnName(AdminRoleModule::class, 'fkAdminRoleId', "agm") .' = '. $queryHelpers->getParameterName(0)
                    ." limit :maxResults offset :firstResult";
    //        var_dump($query);
            return $query;
        }
    ]
];