<?php

namespace IZON\Admin\MVC\Exceptions\Handlers;

use \IZON\Logs\LogLevel;

use \IZON\MVC\Exceptions\Handlers\AppExceptionHandler;

use \IZON\Admin\MVC\Exceptions\AdminPageNotFoundException;

/**
 * Handles if page is not found
 */
class AdminPageNotFoundExceptionHandler implements AppExceptionHandler {
    
    protected $htmlToShow = "www/errors/404.php";
    
    public function getLogLevel() {
        return LogLevel::WARN;
    }

    public function handleException($exception) {
        require __BASE_DIR__. '/'. $this->htmlToShow;
    }

    public function isFor($exception) {
        return $exception instanceof AdminPageNotFoundException;
    }
}
