<?php

namespace IZON\Admin\Domain;

use \IZON\DB\DBObject;

/**
 * nejaka ztavba na kterou se ma odkazovar
 */
class AdminModule implements DBObject {
    
    /**
     * nazev tabulky na kterou se mapuje
     */
    public static function __tableName() { return 'core_admin_modules'; }
    
    /**
     *
     * @var integer 
     */
    protected $id;
//    public static function __id() { return "blah3333"; }

    /**
     * typ modulu
     * @var string
     */
    protected $type;

    /**
     * unikatni identifikator daneh modulu
     * @var string 
     */
    protected $identifier;

    /**
     * 
     * @var string
     */
    protected $name;
//    public static function __name() { return IZON\DB\charField(['maxLength' => 255]); }

    /**
     * @var boolean
     */
    protected $enabled;

    /**
     * urcuje, jestli se ma zobrazovat v adminu
     * @var boolean
     */
    protected $adminVisible;

    /**
     * jak se maji moduly seradit
     * @var integer
     */
    protected $moduleOrder;
    
    /**
     * ikona modulu
     * @var string 
     */
    protected $icon;
    
    /**
     * @var array role ktere mohou k modulu pristupovat 
     */
    protected $roles;
    public static function __roles() { return \IZON\DB\transientField(); }        
    
    /**
     * @var array nastaveni pro modul
     */
    protected $moduleSettings;
    public static function __moduleSettings() { return \IZON\DB\transientField(); }       
    
    /**
     * TODO: az se bude delat uprava co rozbiji spetnou kompatibilitu tak presunout do tabulky
     * @return boolean true is this module is only accessable by superusers
     */
    function getSuperuserOnlyModule() {
        return strstr($this->icon, "superuser") !== false;
    }

//// generated getters and setters    
    function getId() {
        return $this->id;
    }

    function getType() {
        return $this->type;
    }

    function getIdentifier() {
        return $this->identifier;
    }

    function getName() {
        return $this->name;
    }

    function getEnabled() {
        return $this->enabled;
    }

    function getModuleOrder() {
        return $this->moduleOrder;
    }

    function setId($id) {
        $this->id = $id;
    }

    function setType($type) {
        $this->type = $type;
    }

    function setIdentifier($identifier) {
        $this->identifier = $identifier;
    }

    function setName($name) {
        $this->name = $name;
    }

    function setEnabled($enabled) {
        $this->enabled = $enabled;
    }

    function setModuleOrder($moduleOrder) {
        $this->moduleOrder = $moduleOrder;
    }
    
    function getIcon() {
        return $this->icon;
    }

    function setIcon($icon) {
        $this->icon = $icon;
    }
    
    function getAdminVisible() {
        return $this->adminVisible;
    }

    function setAdminVisible($adminVisible) {
        $this->adminVisible = $adminVisible;
    }
    
    function getRoles() {
        return $this->roles;
    }

    function setRoles($roles) {
        $this->roles = $roles;
    }
    
    function getModuleSettings() {
        return $this->moduleSettings;
    }

    function setModuleSettings($moduleSettings) {
        $this->moduleSettings = $moduleSettings;
    }
}

