<?php

namespace IZON\Admin\DI;

use Exception;

use Interop\Container\ContainerInterface;

use DI\FactoryInterface;
use DI\InvokerInterface;
use DI\Proxy\ProxyFactory;

use DI\Definition\Source\DefinitionSource;

use IZON\DI\Container;
use IZON\Admin\DI\Definition\Resolver\ResolverDispatcher;

/**
 * Container pro pristup k modulum
 * 
 * upravena trida z DI\Container
 * 
 */
class ModulesAwareContainer extends Container implements ContainerInterface, FactoryInterface, InvokerInterface {
    
    /**
     * Use the ContainerBuilder to ease constructing the Container.
     *
     * @see ContainerBuilder
     *
     * @param DefinitionSource   $definitionSource
     * @param ProxyFactory       $proxyFactory
     * @param ContainerInterface $wrapperContainer If the container is wrapped by another container.
     */
    public function __construct(
        DefinitionSource $definitionSource,
        ProxyFactory $proxyFactory,
        ContainerInterface $wrapperContainer = null
    ) {
        parent::__construct($definitionSource, $proxyFactory, $wrapperContainer);
        
        $this->definitionResolver = new ResolverDispatcher($this->wrapperContainer, $proxyFactory);
    }
}
