<?php
$locale = \PHPView\getLocale();
?>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<?php
$moduleInfo = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
$moduleName = __('Nástěnka - Administrace');
if($moduleInfo) {
    $moduleName = $moduleInfo->getName() . __(' - Administrace');
}
?>
<title><?= $moduleName ?></title>

<?php
  // PATHS SETTINGS
  $defaultScriptPath          = 'admin/default/static';
  $projectSrciptPathAbsolute  = __BASE_DIR__.'/app/admin/project/static';
  $projectSrciptPathRelative  = 'admin/project/static';
  $scriptsExternal = true;
  // Next "if" is only for backward compatibility
  if(!is_dir(__BASE_DIR__.'/app/admin/default/static')) {
    $defaultScriptPath          = 'admin/static';
    $projectSrciptPathAbsolute  = __BASE_DIR__.'/app/static/admin';
    $projectSrciptPathRelative  = $defaultScriptPath;
    $scriptsExternal = false;
  } 

  // CSS SECTION
  $css = [];
  $css[] = $defaultScriptPath.'/css/style.css';
  $css[] = ['external' => true, 'src' => '//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&amp;subset=latin,latin-ext'];

  // project specific styles
  $_projectStylesPath = $projectSrciptPathAbsolute.'/css/'.($scriptsExternal ? '' : 'project-styles');
  if( file_exists($_projectStylesPath) && is_dir($_projectStylesPath) ) {
      $fileNames = scandir($_projectStylesPath);
      foreach($fileNames as $fileName) {
          if( is_file($_projectStylesPath .'/'. $fileName ) && IZON\String\endsWith($fileName, '.css') ) {
              $css[] = $projectSrciptPathRelative.'/css'.($scriptsExternal ? '' : '/project-styles').'/'.$fileName;
          }
      }
  }
  PHPView\insertScripts($css, 'css', 'admin');
  
  // JS SECTION
  $js = [];
  $js[] = $defaultScriptPath.'/js/app.js';

  // DOTO - devel: NEWVERSION pro zpetnou kompatibilitu na logopedicke, pri vytvoreni nove verze odstranit
  $fileName = __BASE_DIR__.'/app/static/admin/js/fonts-load.js';
  if( file_exists($fileName) ) {
      $js[] = '/admin/static/js/fonts-load.js';
  }

  // project specific srcipts
  $_projectScriptsPath = $projectSrciptPathAbsolute.'/js/'.($scriptsExternal ? '' : 'project-scripts');
  if( file_exists($_projectScriptsPath) && is_dir($_projectScriptsPath) ) {
      $fileNames = scandir($_projectScriptsPath);
      foreach($fileNames as $fileName) {
          if( is_file($_projectScriptsPath .'/'. $fileName ) && IZON\String\endsWith($fileName, ".js") ) { // a konci .js
              $js[] = $projectSrciptPathRelative.'/js'.($scriptsExternal ? '' : '/project-scripts').'/'.$fileName;
          }
      }
  }
  PHPView\insertScripts($js, 'js', 'admin');
  
?>
<script type="text/javascript">
var generalParams = {
    'locale': '<?= $locale->toLocaleTag() ?>',
    'language': '<?= $locale->getLanguage() ?>',
    'country': '<?= $locale->getCountry() ?>',
    
    'fileUploadMaxSize': <?= \PHPView\getParameter("fileUploadMaxSize") ?>, // upload velikost souboru v MB
    'fileUploadMaxSizeB': <?= \PHPView\getParameter("fileUploadMaxSizeB") ?> // upload velikost souboru v B
};

var getNotificationsURL = "<?= \PHPView\getControllerURL("izon.admin.controller.notificationsController", [], "ajaxGetNotificationsJson") ?>";    
//var getNotificationsDelay=10000; // 10 second    
var getNotificationsDelay=120000; // 2 minuty    

// udrzuje admin session otevrenou, pozdeji by melo natahovat nejaka upzorneni
function getNotifications() {
    $.get(getNotificationsURL, function( data ) {
        // zpracovani upozorneni
        
        // spustit dalsi
        setTimeout(getNotifications, getNotificationsDelay);
    });
}

getNotifications();
</script>


<?php
echo adminLoadModuleScripts();
