<?php

namespace IZON\Admin\MVC\Context;

use IZON\MVC\Context\Context;

use IZON\MVC\HttpSession;

use IZON\DBLocale\Domain\Locale as DbLocale;

use IZON\Admin\MVC\ModuleInfo;


/**
 * context specific info for admin
 * contains ModuleInfo of current module, ...
 *
 * @author IZON s.r.o. <info@izon.cz>
 * @copyright Copyright 2017, IZON s.r.o.
 *
 * @package IZON\Admin\MVC\Context
 */
class AdminContext extends Context {
    
    /**
     * @var ModuleInfo 
     */
    protected $moduleInfo;
    
    /**
     *
     * @var \IZON\Admin\Services\SessionService|null
     */
    protected $sessionService;

    
/// generated constructor
    function __construct(HttpSession $session, ModuleInfo $moduleInfo, $sessionService = null) {
        parent::__construct($session);
        $this->moduleInfo = $moduleInfo;
        $this->sessionService = $sessionService;
    }
    
    /**
     * @return DbLocale locale currently used for interface of admin
     */
    public function getInterfaceLocale() {
        if( $this->sessionService === null ) {
            throw new Exception('IZON\Admin\MVC\Routers\AdminRouteDefinition needs to have $sessionService provided to function prepperly');
        }
        return $this->sessionService->getSelectedInterfaceLocale();
    }
    
/// generated getter and setters
    function getModuleInfo() {
        return $this->moduleInfo;
    }

    function setModuleInfo(ModuleInfo $moduleInfo) {
        $this->moduleInfo = $moduleInfo;
    }

    public function getContextId() {
       return "admin";
    }
}
