<?php
/*
 * pomocne funkce pro zobrazovani informaci v adminu
 */

namespace AdminPHPView;

use \IZON\Admin\Config;
use \IZON\MVC\View\PHPView;
use \IZON\Admin\MVC\ModuleInfo;


/**
 *
 * @param string $moduleControllerId jaky controller volat
 * @param string $action jakou akci controlleru volat
 * @param array $params dalsi parametry, ktere predavat
 * @param string $moduleIdentifier jaky modul volat
 * @return string url pomoci ktereho se zavola dany controller
 *
 * TODO: vyresit, aby se nemuselo zadavat $moduleIdentifier pro odkaz do stejneho modulu
 */
function getModuleActionURL($moduleControllerId,
                            $methodName,
                            $params = [],
                            $moduleIdentifier = NULL
) {
    if (empty($moduleIdentifier)) {
        /* @var $activeModule ModuleInfo */
        $activeModule = \PHPView\getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);
        $moduleIdentifier = $activeModule->getIdentifier();
    }
    $controllerId = Config::getModuleEntryName($moduleControllerId,
        $moduleIdentifier);
    $params["action"] = $methodName;

    $view = PHPView::getApplicationView();
    $locale = $view->getLocale();
    // TODO: predavat dovnitr
    $methodName = NULL;
    return $view->getRouter()->findURL($controllerId, $params, $methodName, $locale);
}

/**
 * Vykresli nazev modulu a jeho pripadne akce
 * TODO: sladit s novym zpracovanim menu
 * @param string $title
 */
function renderModuleTitle($title = NULL) {
    $modulesInfos = \PHPView\getParameter("modulesActions");
    $activeModule = \PHPView\getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER);
    $activeMoludeActions = $modulesInfos[$activeModule->getIdentifier()]['actions'];

    $moduleName = $activeModule->getName();

    if (!empty($activeMoludeActions) && is_array($activeMoludeActions)) {
        foreach ($activeMoludeActions as $key => $action) {
            if ($action['controllerId'] == $activeModule->getControllerId()) {
                if ($action['name'] != $moduleName) {
                    $moduleName .= ': ' . $action['name'];
                }
            }
        }
    }
    echo '<div class="col-xs-12">
         <h1>' . $moduleName . (!is_null($title) ? ': <span>' . $title . '</span>' : '') . '</h1>' .
        '</div>';
}

/**
 * Generate a href to change property of
 * @param $thisModule
 * @param \IZON\DB\DBObject $obj
 * @param $propertyName
 * @return string
 * @throws \Exception
 */
function getPropetryCodeToChange($thisModule, \IZON\DB\DBObject $obj, $propertyName) {
    $propertyName = ucfirst($propertyName);
    $class = 'false';
    $getMethod = 'get' . $propertyName;
    $isMethod = 'is' . $propertyName;
    $method = null;
    if (method_exists($obj, $getMethod)){
        $method = $getMethod;
    }else if (method_exists($obj, $isMethod)){
        $method = $isMethod;
    }else{
        throw new \Exception('Class: '. get_class($obj) . ' is not have method ' . $isMethod . ' or ' . $getMethod );
    }

    if($obj->$method()){
        $class = 'true';
    }

    $url = getModuleActionURL($thisModule->getControllerId(), 'changeProperty', ["id" => $obj->getId(), 'propertyName' => $propertyName], $thisModule->getIdentifier());

    return '<a class="' . $class . '" href="' . $url . '"></a>';

}

