<?php

/**
 * funkce pro zjednoduseni vypisu formularovych poli
 */

namespace IZON\Admin\Forms;

use IZON\Forms\Fields\CheckboxField;
use IZON\Forms\Fields\CharField;
use IZON\Forms\Fields\TextField;
use IZON\Forms\Fields\DateFiled;
use IZON\Forms\Fields\EmailField;
use IZON\Forms\Fields\FloatField;
use IZON\Forms\Fields\IntegerField;
use IZON\Forms\Fields\PasswordField;
use IZON\Forms\Fields\SelectField;
use IZON\Forms\Fields\RadioListField;
/**
 * vypise formularove pole pro kratky text
 * @param CharField $field
 * @return string
 */
function getAdminCharField(CharField $field, $size) {
    return '<div class="form__item--'. $size .'">
        <label>'. $field->getLabel() .': </label>
        <input name="'. $field->getFormName() .'" value="'. $field->getValue() .'" type="text" '.$field->getAttributesAsString().(($field->getRequired())?' required':'').'>
    </div>';
}


/**
 * vypisuje formularove pole pro checkbox
 * @param CheckboxField $field
 * @return string
 */
function getAdminCheckboxField(CheckboxField $field, $size) {
    return '<div class="form__item--'. $size .'">
        <input  id="checkbox--'. $field->getFormName() .'" name="'. $field->getFormName() .'" '
            .  ($field->getValue() == true ? "checked" : "")  
            .' type="checkbox" >
        <label for="checkbox--'. $field->getFormName() .'">'. $field->getLabel() .'</label>
    </div>';
}

/**
 * vypisuje formularove pole pro checkbox
 * 
 * @param CheckboxField $field
 * @return string
 */
function __getAdminCheckboxField(CheckboxField $field, $size) {
    return '<div class="form__item--'. $size .'">'.
             '<input  id="checkbox--'. $field->getFormName() .'" name="'. $field->getFormName() .'" '.
                'value="'.$field->getValue().'" '.
                $field->getAttributesAsString().' '.
                ' type="checkbox" >'.
             '<label for="checkbox--'. $field->getFormName() .'">'. $field->getLabel() .'</label>'.
           '</div>';
}

/**
 * vypise formularove pole pro kratky text
 * @param CharField $field
 * @return string
 */
function getAdminTextField(TextField $field, $size) {
   $field->addAttribute('rows', $field->getAttribute('row') + 0 > 0 ? $field->getAttribute('row') : 5);
    return '<div class="form__item--'. $size .'">
        <label>'. $field->getLabel() .': </label>
        <textarea name="'. $field->getFormName() .'" '.$field->getAttributesAsString().'>'. $field->getValue() .'</textarea>
    </div>';
}

/**
 * vypise formularove pole pro date
 * @param DateFiled $field
 * @return string
 */
function getAdminDateFiled(DateFiled $field, $size) {
    return '<div class="form__item--'. $size .'">
        <label>'. $field->getLabel() .': </label>
        <input name="'. $field->getFormName() .'" value="'. $field->getValue() .'" type="date" '.$field->getAttributesAsString().'>
    </div>';
}

/**
 * vypise formularove pole pro email
 * @param EmailField $field
 * @return string
 */
function getAdminEmailField(EmailField $field, $size) {
    return '<div class="form__item--'. $size .'">
        <label>'. $field->getLabel() .': </label>
        <input name="'. $field->getFormName() .'" value="'. $field->getValue() .'" type="email" '.$field->getAttributesAsString().'>
    </div>';
}

/**
 * vypise formularove pole pro cislo desetinne
 * @param FloatField $field
 * @return string
 */
function getAdminFloatField(FloatField $field, $size) {
    return '<div class="form__item--'. $size .'">
        <label>'. $field->getLabel() .': </label>
        <input name="'. $field->getFormName() .'" value="'. $field->getValue() .'" type="number" step="'. $field->getStep() .'"  '.$field->getAttributesAsString().'>
    </div>';
}


/**
 * vypise formularove pole pro cislo cele
 * @param IntegerField $field
 * @return string
 */
function getAdminIntegerField(IntegerField $field, $size) {
    return '<div class="form__item--'. $size .'">
        <label>'. $field->getLabel() .': </label>
        <input name="'. $field->getFormName() .'" value="'. $field->getValue() .'" type="number"  '.$field->getAttributesAsString().'>
    </div>';
}

/**
 * vypise formularove pole pro heslo
 * @param PasswordField $field
 * @return string
 */
function getAdminPasswordField(PasswordField $field, $size) {
    return '<div class="form__item--'. $size .'">
        <label>'. $field->getLabel() .': </label>
        <input name="'. $field->getFormName() .'" type="password"  '.$field->getAttributesAsString().'>
    </div>';
}

/**
 * vypise formularove pole pro selectbox
 * @param PasswordField $field
 * @return string
 */
function getAdminSelectField(SelectField $field, $size) {
    $select = '<div class="form__item--'. $size .'">
        <label>'. $field->getLabel() .': </label>
        <select  name="'. $field->getFormName() .'" '.$field->getAttributesAsString().'>';
        
    foreach($field->getOptions() as $key => $value) {
        $selected = '';
        if( $key == $field->getValue() ) {
            $selected = 'selected';
        }
        $select .= '<option value="'. $key .'" '. $selected .' >'
                    . $value
                    .'</option>';
    }
    
    $select .= '</select>
    </div>';
    
    return $select;
}



/**
 * vypise formularove pole pro radio
 * 
 * @param RadioListField $field
 * @return string
 */
function getAdminRadioField(RadioListField $field, $size, $params = array()) {
    $separator = $params['separator'].'';
    $ret = [];
    foreach($field->getOptions() as $key => $value) {
        $ret[] = '<input '.
                      ($key == $field->getValue() ? 'checked="checked"' : '').
                      'value="'.$key.'" '.
                      'id="radio--'.$key.'-'.$field->getFormName().'" '.
                      'name="'.$field->getFormName().'" '.
                      'type="radio" '.
                      $field->getAttributesAsString().
                    '>'.
                 '<label for="radio--'.$key.'-'.$field->getFormName().'">'. $value .': </label>';
        
    }
    
    return '<div class="form__item--'. $size .' ">'.implode($separator, $ret).'</div>'.LF;
}

/**
 * Vrati html kod formularoveho prvku
 * 
 * @param \IZON\Forms\Form $form
 * @param string $fieldName nazev prvku
 * @param array $params pole s parametry<br>
 * $params['template'] = jaky se ma pouzit template - defaultne "default"<br>
 * $params['raw'] = true - pokud je treba vratit jen input bez labelu, defaultne false <br>
 * $params['noCaption'] = true - pokud je treba vratit input obaleny labelem ale bez textu, defaultne false <br>
 * $params['caption'] - parametry pro popisek pole - struktura obdobna jako u definice tempalte, jen v polich <br>
 * $params['wrapper'] - parametry pro wrapper pole - struktura obdobna jako u definice tempalte, jen v polich<br>
 * $params['field'] - parametry formularove pole - struktura obdobna jako u definice tempalte, jen v polich<br>
 * $params['error'] - parametry formularove pole - struktura obdobna jako u definice tempalte, jen v polich<br>
 * @return string
 */
function getAdminField(\IZON\Forms\Form $form, $fieldName, $params = array()) {
  
  if(!array_key_exists('template', $params) || empty($params['template'])) {
    $params['template'] = 'default';
  }
  return \IZON\Forms\FormFieldTemplate::getFiled($params['template'], \IZON\Forms\FormFieldTemplate::TYPE_BACKEND, $form->getField($fieldName), $params);
}

/**
 * Only wrapper for getAdminField<br>
 * 
 * @param \IZON\Forms\Form $form
 * @param string $fieldName
 * @param array $params
 * @return string
 */
function getField(\IZON\Forms\Form $form, $fieldName, $params = array()) {
  return getAdminField($form, $fieldName, $params);
}
