<?php

namespace IZON\Admin\MVC\Views;

use \Exception;

use \IZON\Logs\Logger;

use \IZON\MVC\View\PHPView;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view 
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
class AdminPHPView extends PHPView {

    /**
     * suffix of view file
     */
    const VIEW_SUFFIX = ".tmpl.php";

    /**
     *
     * @var string cesta ke view, ktere se ma pouzit 
     */
    protected $viewPath;

    /**
     * @var string|null  dir containing global libraries used for all modules 
     */
    protected $librariesDir = null;
    
    /**
     * @var string|null dir containing libraries in selected module for use in view
     */
    protected $moduleLibrariesDir = null;

    /**
     * logger pro tridu
     * @var Logger|null
     */
    protected $log;
    
    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    function __construct($viewName, $viewPath, $librariesDir, $moduleLibrariesDir = null) {
        parent::__construct($viewName);
        $this->viewPath = $viewPath;
        
        $this->librariesDir = $librariesDir;
        $this->moduleLibrariesDir = $moduleLibrariesDir;
        
         // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }

    /**
     * provede vykresleni celeho view
     */
    function render() {
        // load global libraries
        if( $this->librariesDir != NULL ) { // some library dir is set
            foreach(scandir($this->librariesDir) as $file) {
                if( \IZON\String\endsWith($file, ".php") ) {
                    require_once $this->librariesDir ."/". $file;
                }
            }
        }
        // load module view libraries
        if( $this->moduleLibrariesDir != NULL ) { // some library dir is set
            foreach(scandir($this->moduleLibrariesDir) as $file) {
                if( \IZON\String\endsWith($file, ".php") ) {
                    require_once $this->moduleLibrariesDir ."/". $file;
                }
            }
        }
        require_once $this->viewPath;
    }
}