<?php
namespace IZON\Admin\Services\Impl;

use IZON\Admin\Config;

use IZON\Admin\Services\AdminService;
use IZON\Admin\Services\SessionService;

use IZON\DBLocale\Dao\LocaleDao;
use IZON\DBLocale\Dao\CountryDao;
use IZON\DBLocale\Dao\LanguageDao;

use IZON\Admin\Dao\AdminModuleDao;
use IZON\Admin\Dao\AdminModuleSettingDao;

use IZON\Admin\Domain\AdminModule;
use IZON\DBLocale\Domain\Locale;
use IZON\DBLocale\Domain\Country;
use IZON\DBLocale\Domain\Language;

class AdminServiceImpl implements AdminService {    
    
    /**
     * @var AdminModuleDao 
     */
    protected $adminModuleDao;
    
    /**
     * @var AdminModuleSettingDao 
     */
    protected $adminModuleSettingDao;

    /**
     * @var array 
     */
    protected $supportedInterfaceLocaleIdes;

    /**
     * @var LocaleDao 
     */
    protected $localeDao;
    
    /**
     * @var CountryDao 
     */
    protected $countryDao;
    
    /**
     * @var LanguageDao 
     */
    protected $languageDao;

    
    public function __construct(AdminModuleDao $adminModuleDao,
                                AdminModuleSettingDao $adminModuleSettingDao,
                                LocaleDao $localeDao,
                                CountryDao $countryDao,
                                LanguageDao $languageDao) {
        $this->adminModuleDao         = $adminModuleDao;
        $this->adminModuleSettingDao  = $adminModuleSettingDao;
        $this->localeDao              = $localeDao;
        $this->countryDao             = $countryDao;
        $this->languageDao            = $languageDao;
    }
    
    function getActiveModules() {
        return $this->adminModuleDao->findActiveModules()->listResult();
    }
    
    function getLoggedUserModules() {
        return [];
    }

    public function getModuleSetting($moduleIdentifier, $parameterIdentifier) {
        $module = $this->adminModuleDao->find(["identifier" => $moduleIdentifier])->uniqueResult();
        return $this->adminModuleSettingDao->find(["fkAdminModuleId" => $module->getId(), "paramIdentifier" => $parameterIdentifier])->uniqueResult();
    }

    public function getModuleSettings($moduleIdentifier) {
        $module = $this->adminModuleDao->find(["identifier" => $moduleIdentifier])->uniqueResult();
        return $this->adminModuleSettingDao->find(["fkAdminModuleId" => $module->getId()])->listResult();
    }
    
    public function getSupportedCountries() {
        return $this->countryDao->find(['enabled' => 1])->listResult();
    }
    
    public function getSupportedInterfaceLocales() {
        $supportedInterfaceLocales = [];
        foreach($this->supportedInterfaceLocaleIdes as $supportedInterfaceLocaleId) {
            /* @var $locale Locale */
            $locale = $this->localeDao->load($supportedInterfaceLocaleId);
            /* @var $country Country */
            $country = $this->countryDao->load($locale->getFkCountryId());
            $locale->setCountry($country);
            /* @var $language Language */
            $language = $this->languageDao->load($locale->getFkLanguageId());
            $locale->setLanguage($language);
            $supportedInterfaceLocales[] = $locale;
        }
        return $supportedInterfaceLocales;
    }
    
    public function getAdminVersion() {
        $version = json_decode(file_get_contents(__DIR__ .'/../../../../../composer.json'), true)['version'];
        return $version;
    }
    
    function setSupportedInterfaceLocaleIdes(array $supportedInterfaceLocaleIdes = [1]) {
        $this->supportedInterfaceLocaleIdes = $supportedInterfaceLocaleIdes;
    }
}