<?php

namespace IZON\Admin\MVC\Views;

use \Exception;

use \IZON\Logs\Logger;

use IZON\MVC\View\PHPView;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view 
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
class AdminPHPLayoutView extends PHPView {

    /**
     * suffix of template part file
     */
    const PART_SUFFIX = ".tmpl.php";
    
    /**
     * suffix of layout file
     */
    const LAYOUT_SUFFIX = ".lay.php";

    /**
     * name of layout to use
     * @var string
     */
    private $layoutName;

    /**
     * cesty k adresari s views pro jednotlive moduly 
     * @var array 
     */
    protected $modulesPaths;

    /**
     * @var string adresar pro casti adminia specifidke primo pro danou aplikaci/web 
     */
    protected $specificViewsDir;

    /**
     * @var string|null  dir containing global libraries used for all modules 
     */
    protected $librariesDir = null;
    
    /**
     * @var string|null dir containing libraries in selected module for use in view
     */
    protected $moduleLibrariesDir = null;
    
    /**
     * logger pro tridu
     * @var Logger 
     */
    protected $log;
    
    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    function __construct($layoutName, $viewName, array $modulesPaths, $specificViewsDir, $librariesDir, $moduleLibrariesDir = null) {
        parent::__construct($viewName);
        // TODO test na existenci layoutu a adresare s view
        $this->layoutName = $layoutName;
        
        $this->modulesPaths = $modulesPaths;
        
        $this->specificViewsDir = $specificViewsDir;
        
        $this->librariesDir = $librariesDir;
        $this->moduleLibrariesDir = $moduleLibrariesDir;
        
         // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }

    function getLayoutName() {
        return $this->layoutName;
    }

    /**
     * provede vykresleni celeho view
     */
    function render() {
        // load global libraries
        if( $this->librariesDir != NULL ) { // some library dir is set
            foreach(scandir($this->librariesDir) as $file) {
                if( \IZON\String\endsWith($file, ".php") ) {
                    require_once $this->librariesDir ."/". $file;
                }
            }
        }
        
        // load module view libraries
        if( $this->moduleLibrariesDir != NULL ) { // some library dir is set
            foreach(scandir($this->moduleLibrariesDir) as $file) {
                if( \IZON\String\endsWith($file, ".php") ) {
                    require_once $this->moduleLibrariesDir ."/". $file;
                }
            }
        }
        
        require_once $this->layoutName;
    }

    /**
     * provede renderovani soucasti graficleho rozhrani
     */
    function renderLayoutPart($partName) {
        $partFilePath = $this->findLayoutPartFilePath($partName);
        // TODO tady bude test jestli se vubec nejaky soubor nacel
        require_once $partFilePath;
    }

    /**
     * najde cestu k potrebne casti grafickeho rozhrani
     */
    protected function findLayoutPartFilePath($partName) {
        $this->log->info("Calling findLayoutPartFilePath with parameter: [$partName]");
        
        // search all modules tempalte parhs for parts 
        foreach($this->modulesPaths as $modulePath => $shordedViewName) {
            $templatePartFolder = $modulePath ."/". $shordedViewName;
            
            // try language specific file
            $templatePartFile =  $templatePartFolder ."/". $partName .".". $this->getLang() . self::PART_SUFFIX;
            $this->log->info("Trying template $templatePartFile");
            if( file_exists($templatePartFile) 
                && is_file($templatePartFile) ) {
                $this->log->info("Found template $templatePartFile");
                return $templatePartFile;
            }
            
            // try language nonspecific file
            $templatePartFile =  $templatePartFolder ."/". $partName . self::PART_SUFFIX;
            $this->log->info("Trying template $templatePartFile");
            if( file_exists($templatePartFile) 
                && is_file($templatePartFile) ) {
                $this->log->info("Found template $templatePartFile");
                return $templatePartFile;
            }
            
            // zkusit projit stromem ke koreni
            $dirsArray = explode("/", $shordedViewName);
            for($i = count($dirsArray) - 1; $i >= 0; $i--) {
                $dir = $this->createSubdir($dirsArray, $i);
                
                // pokusit se najit part primo ve specific view pro danou aplikaci/web
                $templatePartFile = $this->specificViewsDir ."/". $dir ."/". $partName . self::PART_SUFFIX;
                if( file_exists($templatePartFile) 
                    && is_file($templatePartFile) ) {
                    $this->log->info("Found template $templatePartFile");
                    return $templatePartFile;
                }
                
                
                $templatePartFile =  $modulePath ."/". $dir ."/". $partName .".". $this->getLang() . self::PART_SUFFIX;
                $this->log->info("Trying template $templatePartFile");
                if( file_exists($templatePartFile) 
                    && is_file($templatePartFile) ) {
                    $this->log->info("Found template $templatePartFile");
                    return $templatePartFile;
                }

                // try language nonspecific file
                $templatePartFile =  $modulePath ."/". $dir ."/". $partName . self::PART_SUFFIX;
                if( file_exists($templatePartFile) 
                    && is_file($templatePartFile) ) {
                    $this->log->info("Found template $templatePartFile");
                    return $templatePartFile;
                }
            }
        }
        
        throw new Exception("mrtva vetev");
    }

    /**
     * vytvoti cestu k podadresari podle polozek v poli a poctu polozek, ktere se maji\
     * pozit
     */
    private function createSubdir($subdirsArray, $count) {
        return implode('/', array_slice($subdirsArray, 0, $count));
    }

    // TODO: vracet to co se nastavi ve viewResolveru
    private function findLayoutFilePath() {
        return "app/layouts/" . $this->layoutName . self::LAYOUT_SUFFIX;
    }
}