<?php

namespace IZON\Admin\DI\Definition\Resolver;


use Exception;

use DI\Definition\Definition;
use DI\Definition\Resolver\DefinitionResolver;

use Interop\Container\ContainerInterface;

use IZON\Admin\Config;
use IZON\Admin\DI\Definition\ModuleConfigDefinition;

/**
 * 
 */
class ModuleConfigResolver implements DefinitionResolver
{
    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @param Container $container
     */
    public function __construct(ContainerInterface $container) {
        $this->container = $container;
    }

    /**
     * Resolve an array definition to a value
     *
     * @param ModuleConfigDefinition $definition
     *
     * {@inheritdoc}
     */
    public function resolve(Definition $definition, array $parameters = []) {
        $adminService = $this->container->get(Config::ADMIN_SERVICE_IDENTIFIER);
        $setting = $adminService->getModuleSetting($definition->getModuleIdentifier(),
                                                    $definition->getParamIdentifier());
        
        return $setting->getValue();
    }

    /**
     * {@inheritdoc}
     */
    public function isResolvable(Definition $definition, array $parameters = []) {
        return true;
    }
}
