<?php
// nastavuje obsahovou hlavicku
Header('Content-Type: text/html; charset=utf-8');

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?= __('Přihlášení - Administrace')?></title>

<?php
    // PATHS SETTINGS
    $defaultScriptPath          = 'admin/default/static';
    $projectSrciptPathAbsolute  = __BASE_DIR__.'/app/admin/project/static';
    $projectSrciptPathRelative  = 'admin/project/static';
    $scriptsExternal = true;
    // Next "if" is only for backward compatibility
    if(!is_dir(__BASE_DIR__.'/app/admin/default/static')) {
      $defaultScriptPath          = 'admin/static';
      $projectSrciptPathAbsolute  = __BASE_DIR__.'/app/static/admin';
      $projectSrciptPathRelative  = $defaultScriptPath;
      $scriptsExternal = false;
    } 
    
    // CSS SECTION
    $css = [];
    $css[] = $defaultScriptPath.'/css/style.css';
    $css[] = ['external' => true, 'src' => '//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&amp;subset=latin,latin-ext'];

    // project specific styles
    $_projectStylesPath = $projectSrciptPathAbsolute.'/css/'.($scriptsExternal ? '' : 'project-styles');
    if( file_exists($_projectStylesPath) && is_dir($_projectStylesPath) ) {
        $fileNames = scandir($_projectStylesPath);
        foreach($fileNames as $fileName) {
            if( is_file($_projectStylesPath .'/'. $fileName ) && IZON\String\endsWith($fileName, '.css') ) {
                $css[] = $projectSrciptPathRelative.'/css'.($scriptsExternal ? '' : '/project-styles').'/'.$fileName;
                //echo '<link rel="stylesheet" href="'.PHPView\getURL($projectSrciptPathRelative.'/css'.($scriptsExternal ? '' : 'project-styles').'/'.$fileName .'?='. filemtime($_projectStylesPath .'/'. $fileName)).'">'."\r\n";
            }

        }
    }
    PHPView\insertScripts($css, 'css', 'admin');
?>
</head>

<?php
    PHPView\insertLayoutPart('header');
    PHPView\insertLayoutPart('login-form');
    PHPView\insertLayoutPart('footer'); 
?>
</body>
</html>