<!-- Sidebar -->
<?php
    $activeModule = \PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
    /* @var $loggedUserModules \IZON\Admin\Presentation\Domain\AdminModuleInfo[] */
    $loggedUserModules = \PHPView\getParameter("loggedUserModules");
?>
<nav class="nav">
    <ul>
        <li class="icon--dashboard <?= $activeModule == NULL ? "active" : "" ?>">
            <a href="<?= \PHPView\getControllerURL("izon.admin.controller.dashboardController") ?>"><span><?= __('Nástěnka') ?></span></a>
        </li>
        <?php
            foreach($loggedUserModules as $moduleId => $moduleInfo) {
                $defaultAction = $moduleInfo->getDefaultAction();
                
                $moduleURL = AdminPHPView\getModuleActionURL($defaultAction->getControllerIdentifier(),
                                                                $defaultAction->getMethodName(),
                                                                $defaultAction->getParameters(),
                                                                $moduleInfo->getIdentifier());
                $icon = $moduleInfo->getIcon();
                if( $icon == NULL) {
                    $icon = "list";
                }
            ?>
                <li class="icon--<?= $icon ?> <?= $moduleInfo->isCurrentModule() ? "active" : "" ?>">
                    <a href="<?= $moduleURL ?>"><span><?= $moduleInfo->getModuleName() ?></span></a>
                    <?php
                    if( $moduleInfo->isCurrentModule() ) {
                        $menuActions = $moduleInfo->getModuleMenuActions();
                        echo '<ul>';
                        foreach($menuActions as $menuAction) {
                            $moduleURL = AdminPHPView\getModuleActionURL($menuAction->getControllerIdentifier(),
                                                                        $menuAction->getMethodName(),
                                                                        $menuAction->getParameters(),
                                                                        $moduleInfo->getIdentifier());
                            
                            $class = '';
                            if( $menuAction->isCurrentAction() || $menuAction->isParentAction() ) {
                                $class = 'class="active"';
                            }
                            ?>
                            <li <?= $class ?> ><a href="<?= $moduleURL ?>"><?= $menuAction->getName() ?></a></li>
                            <?php
                        }
                        echo '</ul>';
                    }
                    ?>
                </li>
            <?php
            }
        ?>
    </ul>
</nav>
<!-- /sidebar -->