<?php
$locale = \PHPView\getLocale();
?>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<?php
$moduleInfo = PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
$moduleName = __('Nástěnka - Administrace');
if($moduleInfo) {
    $moduleName = $moduleInfo->getName() . __(' - Administrace');
}
?>
<title><?= $moduleName ?></title>

<link href="<?= PHPView\getURL("admin/static/css/style.css") ?>" rel="stylesheet" type="text/css">
<link href="//fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&amp;subset=latin,latin-ext" rel="stylesheet" type="text/css">
<?php
// nacita specificke css pro projekt
// TODO: lepe resit __BASE_DIR__
$stylesDir = __BASE_DIR__.'/app/static/admin/css/project-styles';
if( file_exists($stylesDir)
    && is_dir($stylesDir) ) {
    $fileNames = scandir($stylesDir);
    foreach($fileNames as $fileName) {
        if( is_file($stylesDir ."/". $fileName ) // je soubor
            && IZON\String\endsWith($fileName, ".css") ) {
            echo '<link rel="stylesheet" href="/admin/static/css/project-styles/'. $fileName .'?='. filemtime($stylesDir ."/". $fileName) .'">'. "\n";
        }
    }
}
?>
<script type="text/javascript" src="<?= PHPView\getURL("admin/static/js/app.js") ?>"></script>
<?php
// TODO: NEWVERSION pro zpetnou kompatibilitu na logopedicke, pri vytvoreni nove verze odstranit
$fileName = __BASE_DIR__.'/app/static/admin/js/fonts-load.js';
if( file_exists($fileName) ) {
    echo '<script type="text/javascript" src="/admin/static/js/fonts-load.js?='. filemtime($fileName) .'"></script>'. "\n";
}
 // nacita specificke js pro projekt
// TODO: lepe resit __BASE_DIR__
$scriptsDir = __BASE_DIR__.'/app/static/admin/js/project-scripts';
if( file_exists($scriptsDir)
    && is_dir($scriptsDir) ) {
    $fileNames = scandir($scriptsDir);
    foreach($fileNames as $fileName) {
        if( is_file($scriptsDir ."/". $fileName ) // je soubor
            && IZON\String\endsWith($fileName, ".js") ) { // a konci .js
            echo '<script type="text/javascript" src="/admin/static/js/project-scripts/'. $fileName .'?='. filemtime($scriptsDir ."/". $fileName) .'"></script>'. "\n";
        }
    }
}
?>
<script type="text/javascript">
var generalParams = {
    'locale': '<?= $locale->toLocaleTag() ?>',
    'language': '<?= $locale->getLanguage() ?>',
    'country': '<?= $locale->getCountry() ?>',
    
    'fileUploadMaxSize': <?= \PHPView\getParameter("fileUploadMaxSize") ?>, // upload velikost souboru v MB
    'fileUploadMaxSizeB': <?= \PHPView\getParameter("fileUploadMaxSizeB") ?> // upload velikost souboru v B
};

var getNotificationsURL = "<?= \PHPView\getControllerURL("izon.admin.controller.notificationsController", [], "ajaxGetNotificationsJson") ?>";    
//var getNotificationsDelay=10000; // 10 second    
var getNotificationsDelay=120000; // 2 minuty    

// udrzuje admin session otevrenou, pozdeji by melo natahovat nejaka upzorneni
function getNotifications() {
    $.get(getNotificationsURL, function( data ) {
        // zpracovani upozorneni
        
        // spustit dalsi
        setTimeout(getNotifications, getNotificationsDelay);
    });
}

getNotifications();
</script>


<?php
echo adminLoadModuleScripts();
