<?php

namespace IZON\Admin\Web\Controllers;

use Exception;

use \IZON\Admin\Services\SessionService;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 * 
 */
class SwitchCountryController implements Controller {
    
    /**
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * @var string|null na ktery controller se ma presmerovat po znene nastaveni zeme
     */
    protected $redirectCotrollerIdentifier = NULL;

    protected $countryCodeParamName = "countryCode";


    public function __construct(SessionService $sessionService,
                                $redirectCotrollerIdentifier) {
        $this->sessionService = $sessionService;
        $this->redirectCotrollerIdentifier = $redirectCotrollerIdentifier;
    }
    
    public function execute(HttpRequest $request) {
        
        if( !$request->hasParameter("countryCode") ) {
            throw new Exception("Neobsahuje parametr countryCode pro změnu jazyka");
        }
        
        $countryCode = $request->getParameter("countryCode");
        $this->sessionService->setSelectedCountry($countryCode);
        
        $modelAndView = ModelAndView::createControllerRedirect($this->redirectCotrollerIdentifier, []);
        return $modelAndView;
    }
}
