<?php
namespace IZON\Admin\Services\Impl;

use IZON\Admin\Config;

use IZON\Admin\Services\AdminService;
use IZON\Admin\Services\SessionService;

use IZON\Admin\Dao\AdminModuleDao;
use IZON\Admin\Dao\AdminModuleSettingDao;
use IZON\DBLocale\Dao\CountryDao;

use IZON\Admin\Domain\AdminModule;


class AdminServiceImpl implements AdminService {    
    
    /**
     * @var AdminModuleDao 
     */
    protected $adminModuleDao;
    
    /**
     * @var AdminModuleSettingDao 
     */
    protected $adminModuleSettingDao;

    /**
     * @var CountryDao 
     */
    protected $countryDao;

    
    public function __construct(AdminModuleDao $adminModuleDao,
                                AdminModuleSettingDao $adminModuleSettingDao,
                                CountryDao $countryDao) {
        $this->adminModuleDao = $adminModuleDao;
        $this->adminModuleSettingDao = $adminModuleSettingDao;
        $this->countryDao = $countryDao;
    }
    
    function getActiveModules() {
        return $this->adminModuleDao->findActiveModules()->listResult();
    }
    
    function getLoggedUserModules() {
        return [];
    }

    public function getModuleSetting($moduleIdentifier, $parameterIdentifier) {
        $module = $this->adminModuleDao->find(["identifier" => $moduleIdentifier])->uniqueResult();
        return $this->adminModuleSettingDao->find(["fkAdminModuleId" => $module->getId(), "paramIdentifier" => $parameterIdentifier])->uniqueResult();
    }

    public function getModuleSettings($moduleIdentifier) {
        $module = $this->adminModuleDao->find(["identifier" => $moduleIdentifier])->uniqueResult();
        return $this->adminModuleSettingDao->find(["fkAdminModuleId" => $module->getId()])->listResult();
    }
    
    public function getSupportedCountries() {
        return $this->countryDao->find(['enabled' => 1])->listResult();
    }
    
    public function getAdminVersion() {
        $version = json_decode(file_get_contents(__DIR__ .'/../../../../../composer.json'), true)['version'];
        return $version;
    }
}