<?php

namespace IZON\Admin\MVC\Context;

use IZON\MVC\Context\Context;

use IZON\MVC\HttpSession;

use IZON\Admin\MVC\ModuleInfo;



/**
 * context specific info for admin
 * contains ModuleInfo of current module, ...
 *
 * @author IZON s.r.o. <info@izon.cz>
 * @copyright Copyright 2017, IZON s.r.o.
 *
 * @package IZON\Admin\MVC\Context
 */
class AdminContext extends Context {
    
    /**
     * @var ModuleInfo 
     */
    protected $moduleInfo;
    
    
/// generated constructor
    function __construct(HttpSession $session, ModuleInfo $moduleInfo) {
        parent::__construct($session);
        $this->moduleInfo = $moduleInfo;
    }
    

/// generated getter and setters
    function getModuleInfo() {
        return $this->moduleInfo;
    }

    function setModuleInfo(ModuleInfo $moduleInfo) {
        $this->moduleInfo = $moduleInfo;
    }

    public function getContextId() {
       return "admin";
    }
}
