<?php

use function IZON\DI\get;

use IZON\Admin\Config;

use \IZON\DB\DaoFactoryBean;

use \IZON\DBLocale\Dao\CountryDao;
use IZON\DBLocale\Dao\LocaleDao;

use IZON\Admin\Dao\AdminModuleDao;
use IZON\Admin\Dao\AdminUserDao;
use IZON\Admin\Dao\AdminModuleSettingDao;
use IZON\Admin\Dao\AdminRoleDao;
use IZON\Admin\Dao\AdminUserRoleDao;
use IZON\Admin\Dao\AdminRoleModuleDao;

use IZON\Admin\Services\Impl\AdminServiceImpl;
use IZON\Admin\Services\Impl\SessionServiceImpl;

use IZON\Admin\Web\Controllers\LoginController;
use IZON\Admin\Web\Controllers\DashboardController;
use IZON\Admin\Web\Controllers\LogoutController;
use IZON\Admin\Web\Controllers\SwitchCountryController;
use IZON\Admin\Web\Controllers\NotificationsController;

use IZON\Admin\Web\Interceptors\LoggedUserCheckInterceptor;
use IZON\Admin\Web\Interceptors\SetLoggedUserInterfaceLocaleInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserInterceptor;
use IZON\Admin\Web\Interceptors\LoggedUserModulesInterceptor;
use IZON\Admin\Web\Interceptors\SupportedCountriesInterceptor;
use IZON\Admin\Web\Interceptors\LoadAdminVersionInterceptor;
use IZON\Admin\Web\Interceptors\LoadMaxFileSizeInterceprtor;

return [
    'izon.admin.dao.adminModuleDao' => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminModuleDao::class),
    'izon.admin.dao.adminUserDao' => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminUserDao::class),
    'izon.admin.dao.adminRoleDao' => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminRoleDao::class),
    'izon.admin.dao.adminUserRoleDao' => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminUserRoleDao::class),
    'izon.admin.dao.adminModuleSettingDao' => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminModuleSettingDao::class),
    /// inicializace pod tridami rozhrani aby fungoval autoresolve
    AdminModuleDao::class => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminModuleDao::class),
    AdminUserDao::class => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminUserDao::class),
    AdminRoleDao::class => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminRoleDao::class),
    AdminUserRoleDao::class => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminUserRoleDao::class),
    AdminModuleSettingDao::class => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminModuleSettingDao::class),
    AdminRoleModuleDao::class => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), AdminRoleModuleDao::class),
    
    
    'izon.admin.dao.CountryDao' => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), CountryDao::class),
    
    'izon.admin.dao.localeDao' => IZON\DI\factoryBean(DaoFactoryBean::class)
                                                    ->constructor(\IZON\DI\get('db.connection'), LocaleDao::class),
    
    Config::ADMIN_SERVICE_IDENTIFIER => IZON\DI\object(AdminServiceImpl::class)
                                                    ->constructor(\IZON\DI\get('izon.admin.dao.adminModuleDao'),
                                                                    \IZON\DI\get('izon.admin.dao.adminModuleSettingDao'),
                                                                    \IZON\DI\get('izon.admin.dao.CountryDao')),
    
    // TODO: umoznit jeho prepsani v configu
    'izon.admin.service.adminSessionService' => IZON\DI\object(SessionServiceImpl::class)
                                                    ->constructor(
                                                                get(Config::CONFIG_DIR_IDENTIFIER),
                                                                get("admin.modulesActions"),
                                                                get("admin.modulesLocaltions"),
                                                                get('izon.admin.dao.adminUserDao'),
                                                                get('izon.admin.dao.adminRoleDao'),
                                                                get('izon.admin.dao.adminModuleDao'),
                                                                get('izon.admin.dao.CountryDao'),
                                                                get('izon.admin.dao.localeDao'),
                                                                get('locale.dir'),
                                                                get('develserver'),
                                                                get('serverSystem')),
    
    //// controllery pro admin
    // controller pro prihlaseni a odhlaseni
    Config::LOGIN_CONTROLLER_IDENTIFIER => IZON\DI\object(LoginController::class)
                                                    ->constructor(\IZON\DI\get('izon.admin.service.adminSessionService'),
                                                                 Config::DASHBOARD_CONTROLLER_IDENTIFIER),
    
    // controller pro uvodku adminu
    Config::DASHBOARD_CONTROLLER_IDENTIFIER => IZON\DI\object(DashboardController::class)
                                                    ->constructor(\IZON\DI\get(Config::ADMIN_SERVICE_IDENTIFIER)),
    
    // controller pro odhlaseni z admina
    Config::LOGOUT_CONTROLLER_IDENTIFIER => IZON\DI\object(LogoutController::class)
                                                    ->constructor(\IZON\DI\get('izon.admin.service.adminSessionService'),
                                                                Config::LOGIN_CONTROLLER_IDENTIFIER),
    
    // controller pro zmenu jazyka
    Config::SWITCH_COUNTRY_CONTROLLER_IDENTIFIER => IZON\DI\object(SwitchCountryController::class)
                                                    ->constructor(\IZON\DI\get('izon.admin.service.adminSessionService'),
                                                                 Config::DASHBOARD_CONTROLLER_IDENTIFIER),
    
    // controller pro spravu notifikaci
    Config::NOTIFICATIONS_CONTROLLER_IDENTIFIER => IZON\DI\object(NotificationsController::class)
                                                    ->constructor(\IZON\DI\get(Config::ADMIN_SERVICE_IDENTIFIER)),
    
    
    //// interceptory pro admin
    // interceptor pro kontrolu prihlaseneho uzivatele
    Config::LOGGED_USER_CHECK_INTERCEPTOR_IDENTIFIER => IZON\DI\object(LoggedUserCheckInterceptor::class)
                                                    ->constructor(\IZON\DI\get('izon.admin.service.adminSessionService')),
    
    // interceptor pro nacteni prihlaseneho uzivatele
    Config::SET_LOGGED_USER_INTERFACE_LOCALE_INTERCEPTOR => IZON\DI\object(SetLoggedUserInterfaceLocaleInterceptor::class)
                                                    ->constructor(\IZON\DI\get('izon.admin.service.adminSessionService')),
    
    // interceptor pro nacteni prihlaseneho uzivatele
    Config::LOGGED_USER_INTERCEPTOR_IDENTIFIER => IZON\DI\object(LoggedUserInterceptor::class)
                                                    ->constructor(\IZON\DI\get('izon.admin.service.adminSessionService')),
    
    // interceptor pro nacteni akci admina
    Config::MODULES_ACTIONS_INTERCEPTOR_IDENTIFIER => IZON\DI\object(LoggedUserModulesInterceptor::class)
                                                    ->constructor(\IZON\DI\get('izon.admin.service.adminSessionService'),
                                                                    \IZON\DI\get('admin.modulesActions')),
    
    // interceptor pro nacteni akci admina
    Config::MODULES_SUPPORTED_COUNTRIES_INTERCEPTOR_IDENTIFIER => IZON\DI\object(SupportedCountriesInterceptor::class)
                                                    ->constructor(\IZON\DI\get(Config::ADMIN_SERVICE_IDENTIFIER)),
    
    // nacte verzi admina
    Config::ADMIN_VERSION_INTERCEPTOR_IDENTIFIER => IZON\DI\object(LoadAdminVersionInterceptor::class)
                                                    ->constructor(\IZON\DI\get(Config::ADMIN_SERVICE_IDENTIFIER)),
    
    //nacte max file size
    Config::ADMIN_MAX_FILE_SIZE_INTERCEPTOR_IDENTIFIER => IZON\DI\object(LoadMaxFileSizeInterceprtor::class),
                                                    
];