<!-- Sidebar -->
<?php 
    $modulesInfos = \PHPView\getParameter("modulesActions");
    $activeModule = \PHPView\getParameter(IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
?>
<nav class="nav">
    <ul>
        <li class="icon--dashboard <?= $activeModule == NULL ? "active" : "" ?>">
            <a href="/admin/dashboard/"><span><?= __('Nástěnka') ?></span></a>
        </li>
        <?php
            foreach($modulesInfos as $moduleId => $moduleInfo) {
                $defaultActionId = $moduleInfo["defaultAction"];
                $defaultAction = $moduleInfo["actions"][$defaultActionId];
                $moduleURL = AdminPHPView\getModuleActionURL($defaultAction["controllerId"],
                                                                $defaultAction["action"],
                                                                [],
                                                                $moduleInfo["identifier"]);
                $icon = $moduleInfo["icon"];
                if( $icon == NULL) {
                    $icon = "list";
                }
                ?>
                <li class="icon--<?= $icon ?> <?= $activeModule != NULL && $activeModule->getIdentifier() == $moduleId ? "active" : "" ?>">
                    <a href="<?= $moduleURL ?>"><span><?= $moduleInfo["name"] ?></span></a>
                    <?php
                    $menuActions = $moduleInfo["menuActions"];
                    if( !empty($menuActions) ) {
                        echo '<ul>';
                        foreach($menuActions as $menuActionId) {
                            $moduleAction = $moduleInfo["actions"][$menuActionId];
                            $moduleURL = AdminPHPView\getModuleActionURL($moduleAction["controllerId"],
                                                                        $moduleAction["action"],
                                                                        [],
                                                                        $moduleInfo["identifier"]);
                            
                            $class = '';
                            if($activeModule != NULL 
                                && $activeModule->getIdentifier() == $moduleId
                                && $activeModule->getControllerId() == $moduleAction["controllerId"]
                                && $activeModule->getAction() == $moduleAction["action"]) {
                                $class = 'class="active"';
                            }
                            ?>
                            <li <?= $class ?> ><a href="<?= $moduleURL ?>"><?= $moduleAction["name"] ?></a></li>
                            <?php
                        }
                        echo '</ul>';
                    }
                    ?>
                </li>
                <?php
            }
        ?>
    </ul>
</nav>
<!-- /sidebar -->