<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Services\AdminService;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;

use IZON\MVC\ModelAndView;

/**
 * zpristupni prihlaseneho uzivatele pro view
 */
class SupportedCountriesInterceptor implements Interceptor
{
    /**
     *
     * @var AdminService
     */
    protected $adminService;

    /**
     * pod jakym jemnem se ma zpristupnit ve view
     * @var string
     */
    protected $supportedCountriesModelName = "adminSupportedCountries";
    
    
    public function __construct(AdminService $adminService)
    {
        $this->adminService = $adminService;
    }
    
    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $countries = $this->adminService->getSupportedCountries();
        $model->putParameter($this->supportedCountriesModelName, $countries);
        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
    }
}
