<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Services\SessionService;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;

use IZON\MVC\ModelAndView;

/**
 * zpristupni prihlaseneho uzivatele pro view
 */
class LoggedUserInterceptor implements Interceptor
{
    /**
     *
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * pod jakym jemnem se ma zpristupnit ve view
     * @var string
     */
    protected $loggedUserModelName = "adminLoggedUser";
    
    public function __construct(SessionService $sessionService)
    {
        $this->sessionService = $sessionService;
    }
    
    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $loggedUser = $this->sessionService->getLoggedUser();
        $model->putParameter($this->loggedUserModelName, $loggedUser);
        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
    }
}
