<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Config;
use IZON\Admin\Services\SessionService;
use IZON\Logs\Logger;
use IZON\MVC\HttpRequest;

use IZON\MVC\Interceptors\Interceptor;

use IZON\MVC\Interceptors\PreHandleResult;
use IZON\MVC\ModelAndView;

/**
 * kontroluje jestli je prihlasen spravny uzivatel jestli ne prehodi ho na
 * login obrazovku
 */
class LoggedUserCheckInterceptor implements Interceptor
{
    /**
     *
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * logger pro tridu
     * @var Logger
     */
    protected $log;
    
    
    public function __construct(SessionService $sessionService)
    {
        $this->sessionService = $sessionService;
        
        // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }
    
    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
        if (!$this->sessionService->isUserLoggedIn()) {
            $this->log->info("User not logged in. Redirect to login page");

            $preHandleResult = PreHandleResult::getInternalRedirect(Config::LOGIN_CONTROLLER_IDENTIFIER);
            
            return $preHandleResult;
        }
    }
}
