<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\MVC\ModuleInfo;

use IZON\Admin\Services\AdminService;
use IZON\Logs\Logger;
use IZON\MVC\HttpRequest;

use IZON\MVC\Interceptors\Interceptor;

use IZON\MVC\ModelAndView;

/**
 *
 * nacita informace o akcich modulu
 * a o aktualnim zobrazovanem modulu
 */
class LoadedModulesInterceptor implements Interceptor
{
    /**
     * @var AdminService
     */
    protected $adminService;
    
    protected $modulesActions = null;


    /**
     * logger pro tridu
     * @var Logger
     */
    protected $log;
    
    
    public function __construct(
        AdminService $adminService,
        array $modulesActions
    ) {
        $this->adminService = $adminService;
        $this->modulesActions = $modulesActions;
        
        // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }
    
    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function preHandle(HttpRequest $request)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $userModulesActions = [];
        $modules = $this->adminService->getLoggedUserModules();
        foreach ($modules as $module) {
            $userModulesActions[$module->getIdentifier()] = $this->modulesActions[$module->getIdentifier()];
        }

        // adds information of all active modules for user
        $model->putParameter("modulesActions", $userModulesActions);
        // adds info of current module
        $model->putParameter(
            ModuleInfo::MODULE_INFO_INDENTIFIER,
            $request->getParameter(ModuleInfo::MODULE_INFO_INDENTIFIER)
        );
        return $model;
    }
}
