<?php

namespace IZON\Admin\Web\Interceptors;

use IZON\Admin\Services\AdminService;
use IZON\MVC\HttpRequest;
use IZON\MVC\Interceptors\Interceptor;

use IZON\MVC\ModelAndView;

/**
 *  nacte verzi admina
 */
class LoadAdminVersionInterceptor implements Interceptor
{
    /**
     * @var AdminService
     */
    protected $adminService;

    
    public function __construct(AdminService $adminService)
    {
        $this->adminService = $adminService;
    }
    
    public function afterCompletion(HttpRequest $request, $exception)
    {
    }

    public function postHandle(HttpRequest $request, ModelAndView $model)
    {
        $adminVersion = $this->adminService->getAdminVersion();
        $model->putParameter("adminVersion", $adminVersion);
        return $model;
    }

    public function preHandle(HttpRequest $request)
    {
    }
}
