<?php

namespace IZON\Admin\Web\Controllers;

use IZON\Admin\Services\SessionService;

use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;
use IZON\MVC\ModelAndView;

/**
 *
 */
class LogoutController implements Controller
{
    /**
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * defaultni controller na ktery sa ma po loginu presmerovat
     * @var string
     */
    protected $loginCotrollerIdentifier = null;
    
    /**
     * jake view se ma pouzit pro zobrazeni formulare
     * @var string
     */
    protected $loginFormViewName = "admin/login";

    
    public function __construct(SessionService $sessionService)
    {
        $this->sessionService = $sessionService;
        
        $this->loginCotrollerIdentifier = \IZON\Admin\Config::LOGIN_CONTROLLER_IDENTIFIER;
    }
    
    public function logout(HttpRequest $request)
    {
        $this->sessionService->logoutUser();
        $modelAndView = new ModelAndView($this->loginCotrollerIdentifier, [], true);
        return $modelAndView;
    }
}
