<?php

namespace IZON\Admin\Web\Controllers;

use Exception;

use IZON\Admin\Services\SessionService;

use IZON\Forms\Form;
use IZON\MVC\Controller;
use IZON\MVC\HttpRequest;


use IZON\MVC\ModelAndView;

/**
 *
 */
class LoginController implements Controller
{
    /**
     * @var SessionService
     */
    protected $sessionService;
    
    /**
     * defaultni controller na ktery sa ma po loginu presmerovat
     * @var string
     */
    protected $dashboardCotrollerIdentifier = null;
    
    /**
     * jake view se ma pouzit pro zobrazeni formulare
     * @var string
     */
    protected $loginFormViewName = "admin/login";

    
    public function __construct(SessionService $sessionService)
    {
        $this->sessionService = $sessionService;
        
        $this->dashboardCotrollerIdentifier = \IZON\Admin\Config::DASHBOARD_CONTROLLER_IDENTIFIER;
    }
    
    public function login(HttpRequest $request)
    {
        $loginForm = $this->createLoginForm($request);
        $loginForm->setValues($request->getParameters());
        
        // neni vyplneny zadny login
        if ($loginForm->getField("login")->parse() == '') {
            $modelAndView = new ModelAndView($this->loginFormViewName, ["loginForm" => $loginForm]);
            return $modelAndView;
        }
        
        // pokusit se prihlasit
        try {
            $this->sessionService->loginUser(
                $loginForm->getField("login")->parse(),
                $loginForm->getField("password")->parse()
            );
            $modelAndView = new ModelAndView($this->dashboardCotrollerIdentifier, [], true);
            return $modelAndView;
        } catch (Exception $e) {
            $modelAndView = new ModelAndView($this->loginFormViewName, ["loginForm" => $loginForm, "loginError" => true]);
        }
        
        return $modelAndView;
    }
    
    protected function createLoginForm(HttpRequest $request)
    {
        $form = new Form();
        $form->addCharField("login", "Login");
        $form->addPasswordField("password", "Heslo");
        return $form;
    }
}
