<?php

namespace IZON\Admin\Services;

use IZON\DB\DBObject;
use IZON\DB\Paginator\PageContent;
use IZON\DB\Paginator\PaginatorConfig;

/**
 * Jesnoducy servis pro vytvoreni editace jedne tridy
 *
 * umoznuje:
 * - natahnout stranky se seznamem polozek
 * - natahnout jednu polozku
 * - ulozit novou polozku
 * - updatovat existujici polozku
 */
interface SimpleAdminService
{
    public const DEFAULT_MAX_PAGE_SIZE = 100;
    
    /**
     * vrati defaultni strankovac
     * @return PaginatorConfig konfigurace podle ktere se ma strankovat
     */
    public function getPaginatorConfig(
        $name = PaginatorConfig::DEFAULT_PAGINATOR_NAME,
        $definedFields = [],
        $maxPageSize = self::DEFAULT_MAX_PAGE_SIZE
    );
    
    /**
     * vrati aktivni moduly
     * @param PaginatorConfig $config jak se ma vytahnout strana
     * @return PageContent
     */
    public function getPage(PaginatorConfig $config);
    
    /**
     * vrati objekt s danym id nebo vyhodi nenalezeno vyjimky
     * TODO: vytvorit nejakou takovou vijimku v db vrstve
     * @param type $id
     */
    public function get($id);
    
    /**
     * @param DBObject $obj object to update
     */
    public function update($obj);
    
    /**
     * @param DBObject $obj new object to save
     */
    public function save($obj);
    
    /**
     * delete objedt with provided id
     * @param key $id
     */
    public function delete($id);
}
