<?php

namespace IZON\Admin\Services;

use IZON\Admin\Domain\AdminUser;

/**
 * Servis slouzici k udrzovani iiformaci o prihlasenem uzivateli a
 * k prihlaseni a odhlaseni uzivatele
 */
interface SessionService
{
    /**
     * prihlasi uzivatele nebo vyhodi vyjimu proc to neni mozne
     * @param string $login
     * @param string $password
     */
    public function loginUser($login, $password);
    
    /**
     * odhlasi v soucasnosti prihlaseneho uzivatele
     */
    public function logoutUser();
    
    /**
     * vraci true pokud je do aplikace prihlsen uzivatel
     * @return boolean
     */
    public function isUserLoggedIn();
    
    /**
     * @return AdminUser currently logged user
     * @throws Exception if user isn't logged in
     */
    public function getLoggedUser();
}
