<?php

namespace IZON\Admin\Services\Impl;

use IZON\Admin\Services\SimpleAdminService;
use IZON\DB\Dao;

use IZON\DB\Paginator\PaginatorConfig;

/**
 * Jesnoducy servis pro vytvoreni editace jedne tridy
 *
 * umoznuje:
 * - natahnout stranky se seznamem polozek
 * - natahnout jednu polozku
 * - ulozit novou polozku
 * - updatovat existujici polozku
 */
class SimpleAdminServiceImpl implements SimpleAdminService
{
    /**
     * dao to access edited object
     * @var Dao
     */
    protected $objectDao;
    
    
    public function __construct(Dao $objectDao)
    {
        $this->objectDao = $objectDao;
    }
    
    /**
     * vrati defaultni strankovac
     */
    public function getPaginatorConfig(
        $name = PaginatorConfig::DEFAULT_PAGINATOR_NAME,
        $definedFields = [],
        $maxPageSize = SimpleAdminService::DEFAULT_MAX_PAGE_SIZE
    ) {
        $pagetConfig = new PaginatorConfig($name, $definedFields, $maxPageSize);
        return $pagetConfig;
    }
    
    /**
     * vrati aktivni moduly
     */
    public function getPage(PaginatorConfig $config)
    {
        return $this->objectDao->paginate($config);
    }
    
    /**
     * vrati objekt s danym id nebo vyhodi nenalezeno vyjimky
     * TODO: vytvorit nejakou takovou vijimku v db vrstve
     * @param type $id
     */
    public function get($id)
    {
        return $this->objectDao->load($id);
    }
    
    public function update($obj)
    {
        $this->objectDao->update($obj);
    }
    
    public function save($obj)
    {
        return $this->objectDao->save($obj);
    }

    public function delete($id)
    {
        $this->objectDao->delete($id);
    }
}
