<?php

namespace IZON\Admin\Services\Impl;

use Exception;

use IZON\Admin\Dao\AdminUserDao;

use IZON\Admin\Domain\AdminUser;

use IZON\Admin\Services\SessionService;

/**
 * Servis provadejici ostavu session ziskavane z db AdminUser
 */
class SessionServiceImpl implements SessionService
{
    /**
     * dao pro pristup k uzivatelum
     * @var AdminUserDao
     */
    protected $adminUserDao;

    /**
     * pod jakym jmenem je uzivatel ulozen v session
     * @var
     */
    protected $adminUserSessionName = "logedAdminUser";

    /**
     *
     */
    public function __construct(AdminUserDao $adminUserDao)
    {
        $this->adminUserDao = $adminUserDao;
    }

    /**
     * prihlasi uzivatele nebo vyhodi vyjimku proc to neni mozne
     * @param string $login
     * @param string $password
     */
    public function loginUser($login, $password)
    {
        // TODO nepouzivat global
        $user = $this->adminUserDao->findUserByLogin($login)->uniqueResult();
        if ($user == null) {
            throw new Exception("Pro login $login neexistuje uzivatel", 100);
        }
        if (!$this->isPasswordCorrect($user, $password)) {
            throw new Exception("Pro login $login nesouhlasí heslo", 200);
        }

        // TODO: asi kontrola ze je uz nekdo prihlasen
        session_start();
        $_SESSION[$this->adminUserSessionName] = $user;
        session_write_close();
    }

    /**
     * odhlasi v soucasnosti prihlaseneho uzivatele
     */
    public function logoutUser()
    {
        // nastartuj session
        session_start();
        // a zlikviduj session
        session_destroy();
    }

    /**
     * zkontroluje jestli zadane heslo odpovida zadanemu
     * @param AdminUser $user
     */
    protected function isPasswordCorrect($user, $password)
    {
        // TODO: doplnit hashovani a nasoleni
        return password_verify($password, $user->getPassword());
    }

    public function isUserLoggedIn()
    {
        session_start();
        $retval = isset($_SESSION[$this->adminUserSessionName]);
        session_write_close();
        return $retval;
    }

    public function getLoggedUser()
    {
        session_start();
        if (!isset($_SESSION[$this->adminUserSessionName])) {
            throw new Exception("User isn't logged in");
        }
        $retval = $_SESSION[$this->adminUserSessionName];
        session_write_close();
        return $retval;
    }

    protected function getPasswordHash($password)
    {
        // use blowfish hash function with cost 10 ai. 10^10 iterations
        $options = [
            'cost' => 10,
        ];
        $hash = password_hash($password, PASSWORD_BCRYPT, $options);

        return $hash;
    }
}
