<?php

namespace IZON\Admin\Services\Impl;

use IZON\Admin\Dao\AdminModuleDao;
use IZON\Admin\Dao\AdminModuleSettingDao;

use IZON\Admin\Services\AdminService;
use IZON\Admin\Services\SessionService;

class AdminServiceImpl implements AdminService
{
    /**
     *
     * @var SessionService
     */
    protected $sessionService;

    /**
     * @var AdminModuleDao
     */
    protected $adminModuleDao;

    /**
     * @var AdminModuleSettingDao
     */
    protected $adminModuleSettingDao;


    public function __construct(
        SessionService $sessionService,
        AdminModuleDao $adminModuleDao,
        AdminModuleSettingDao $adminModuleSettingDao
    ) {
        $this->sessionService = $sessionService;
        $this->adminModuleDao = $adminModuleDao;
        $this->adminModuleSettingDao = $adminModuleSettingDao;
    }

    public function getActiveModules()
    {
        return $this->adminModuleDao->findActiveModules()->listResult();
    }

    public function getLoggedUserModules()
    {
        if (!$this->sessionService->isUserLoggedIn()) {
            return [];
        }
        $user = $this->sessionService->getLoggedUser();
        if ($user->getSuperuser()) {
            // TODO: rozlisit jestli je uzivatel superuser nebo ne
            return $this->adminModuleDao->findAdminVisibleModules()->listResult();
        } else {
            return $this->adminModuleDao->findUserAdminVisibleModules($user->getId())->listResult();
        }
    }

    public function getModuleSetting($moduleIdentifier, $parameterIdentifier)
    {
        $module = $this->adminModuleDao->find(["identifier" => $moduleIdentifier])->uniqueResult();
        return $this->adminModuleSettingDao->find(["moduleId" => $module->getId(), "paramIdentifier" => $parameterIdentifier])->uniqueResult();
    }

    public function getAdminVersion()
    {
        $version = json_decode(
            file_get_contents(dirname(__DIR__, 3) . '/composer.json'),
            true
        )['version'];
        return $version;
    }
}
