<?php

/*
 * pomocne funkce pro zobrazovani informaci v adminu
 */


/**
 * provadi preklad gettextu pro admina
 * @param string $key
 * @return type
 */
function __($key)
{
    return $key;
}

/**
 * Pro zadane pole vrati do hlavicky kody pro nacteni dodacetcnych css a js
 *
 * array(src => [nazev lokalniho souboru|komplet adersa na externi zdroj],<br>
 *       type => [css|js], <br>
 *       external => [true|false],<br>
 *       media => typ media pro css, default "all")<br>
 *
 * @param array $additional
 * @return string
 */
function adminLoadScripts($additional)
{
    define(LF, "\r\n");
    $basePath = \PHPView\getParameter(\IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER)->getType() . '/static/';
    $buff = '';
    if (!empty($additional) && is_array($additional)) {
        foreach ($additional as $key => $value) {
            if (empty($value)) {
                continue;
            }
            if ($value['external']) {
                if ($value['type'] == 'js') {
                    $buff .= '<script type="text/javascript" src="' . $value['src'] . '"></script>' . LF;
                } elseif ($value['type'] == 'css') {
                    $buff .= '<link  href="' . $value['src'] . '" rel="stylesheet" type="text/css" media="' . ($value['media'] != '' ? $value['media'] : 'all') . '" />' . LF;
                }
            } else {
                $filePath = $basePath . $value['type'] . '/' . $value['src'] . '.' . $value['type'];
                if (!file_exists(WEB_ROOT_DIR . '/vendor/' . $filePath)) {
                    continue;
                }
                #
                $filePath = '/modules/' . $filePath . '?' . time();
                if ($value['type'] == 'js') {
                    $buff .= '<script type="text/javascript" src="' . $filePath . '"></script>' . LF;
                } elseif ($value['type'] == 'css') {
                    $buff .= '<link href="' . $filePath . '" rel="stylesheet" type="text/css" media="' . ($value['media'] != '' ? $value['media'] : 'all') . '" />' . LF;
                }
            }
        }
    }
    return $buff;
}
/**
 * nacte pro modul css a js ulozena v adresari static/[css|js]
 * nejde do podadresaru.
 *
 * @return string
 */
function adminLoadModuleScripts()
{
    define(LF, "\r\n");
    $buff = '';
    $module = \PHPView\getParameter(\IZON\Admin\MVC\ModuleInfo::MODULE_INFO_INDENTIFIER);
    if ($module instanceof \IZON\Admin\MVC\ModuleInfo) {
        $basePath = $module->getType() . '/static/';

        $_basePath = WEB_ROOT_DIR . '/vendor/' . $basePath;
        if (is_dir($_basePath . 'css/')) {
            foreach (scandir($_basePath . 'css/') as $file) {
                if (in_array($file, ['.', '..'])
                    || is_dir($_basePath . 'css/' . $file)) {
                    continue;
                }
                $filePath = '/modules/' . $basePath . 'css/' . $file . '?' . time();
                $buff .= '<link href="' . $filePath . '" rel="stylesheet" type="text/css" media="all" />' . LF;
            }
        }
        if (is_dir($_basePath . 'js/')) {
            foreach (scandir($_basePath . 'js/') as $file) {
                if (in_array($file, ['.', '..'])
                    || is_dir($_basePath . 'js/' . $file)) {
                    continue;
                }
                $filePath = '/modules/' . $basePath . 'js/' . $file . '?' . time();
                $buff .= '<script type="text/javascript" src="' . $filePath . '"></script>' . LF;
            }
        }
    }
    return $buff;
}
