<?php

/**
 * funkce pro zjednoduseni vypisu formularovych poli
 */

namespace IZON\Admin\Forms;

use IZON\Forms\Fields\CharField;
use IZON\Forms\Fields\CheckboxField;
use IZON\Forms\Fields\DateFiled;
use IZON\Forms\Fields\EmailField;
use IZON\Forms\Fields\FloatField;
use IZON\Forms\Fields\IntegerField;
use IZON\Forms\Fields\PasswordField;
use IZON\Forms\Fields\RadioListField;
use IZON\Forms\Fields\SelectField;
use IZON\Forms\Fields\TextField;

/**
 * vypise formularove pole pro kratky text
 * @param CharField $field
 * @return string
 */
function getAdminCharField(CharField $field, $size)
{
    return '<div class="form__item--' . $size . '">
        <label>' . $field->getLabel() . ': </label>
        <input name="' . $field->getFormName() . '" value="' . $field->getValue() . '" type="text" ' . $field->getAttributesAsString() . (($field->getRequired()) ? ' required' : '') . '>
    </div>';
}


/**
 * vypisuje formularove pole pro checkbox
 * @param CheckboxField $field
 * @return string
 */
function getAdminCheckboxField(CheckboxField $field, $size)
{
    return '<div class="form__item--' . $size . '">
        <input  id="checkbox--' . $field->getFormName() . '" name="' . $field->getFormName() . '" '
            . ($field->getValue() == ture ? "checked" : "")
            . ' type="checkbox" >
        <label for="checkbox--' . $field->getFormName() . '">' . $field->getLabel() . '</label>
    </div>';
}

/**
 * vypisuje formularove pole pro checkbox
 *
 * @param CheckboxField $field
 * @return string
 */
function __getAdminCheckboxField(CheckboxField $field, $size)
{
    return '<div class="form__item--' . $size . '">' .
             '<input  id="checkbox--' . $field->getFormName() . '" name="' . $field->getFormName() . '" ' .
                'value="' . $field->getValue() . '" ' .
                $field->getAttributesAsString() . ' ' .
                ' type="checkbox" >' .
             '<label for="checkbox--' . $field->getFormName() . '">' . $field->getLabel() . '</label>' .
           '</div>';
}

/**
 * vypise formularove pole pro kratky text
 * @param CharField $field
 * @return string
 */
function getAdminTextField(TextField $field, $size)
{
    $field->addAttribute('rows', $field->getAttribute('row') + 0 > 0 ? $field->getAttribute('row') : 5);
    return '<div class="form__item--' . $size . '">
        <label>' . $field->getLabel() . ': </label>
        <textarea name="' . $field->getFormName() . '" ' . $field->getAttributesAsString() . '>' . $field->getValue() . '</textarea>
    </div>';
}

/**
 * vypise formularove pole pro date
 * @param DateFiled $field
 * @return string
 */
function getAdminDateFiled(DateFiled $field, $size)
{
    return '<div class="form__item--' . $size . '">
        <label>' . $field->getLabel() . ': </label>
        <input name="' . $field->getFormName() . '" value="' . $field->getValue() . '" type="date" ' . $field->getAttributesAsString() . '>
    </div>';
}

/**
 * vypise formularove pole pro email
 * @param EmailField $field
 * @return string
 */
function getAdminEmailField(EmailField $field, $size)
{
    return '<div class="form__item--' . $size . '">
        <label>' . $field->getLabel() . ': </label>
        <input name="' . $field->getFormName() . '" value="' . $field->getValue() . '" type="email" ' . $field->getAttributesAsString() . '>
    </div>';
}

/**
 * vypise formularove pole pro cislo desetinne
 * @param FloatField $field
 * @return string
 */
function getAdminFloatField(FloatField $field, $size)
{
    return '<div class="form__item--' . $size . '">
        <label>' . $field->getLabel() . ': </label>
        <input name="' . $field->getFormName() . '" value="' . $field->getValue() . '" type="number" step="' . $field->getStep() . '"  ' . $field->getAttributesAsString() . '>
    </div>';
}


/**
 * vypise formularove pole pro cislo cele
 * @param IntegerField $field
 * @return string
 */
function getAdminIntegerField(IntegerField $field, $size)
{
    return '<div class="form__item--' . $size . '">
        <label>' . $field->getLabel() . ': </label>
        <input name="' . $field->getFormName() . '" value="' . $field->getValue() . '" type="number"  ' . $field->getAttributesAsString() . '>
    </div>';
}

/**
 * vypise formularove pole pro heslo
 * @param PasswordField $field
 * @return string
 */
function getAdminPasswordField(PasswordField $field, $size)
{
    return '<div class="form__item--' . $size . '">
        <label>' . $field->getLabel() . ': </label>
        <input name="' . $field->getFormName() . '" type="password"  ' . $field->getAttributesAsString() . '>
    </div>';
}

/**
 * vypise formularove pole pro selectbox
 * @param PasswordField $field
 * @return string
 */
function getAdminSelectField(SelectField $field, $size)
{
    $select = '<div class="form__item--' . $size . '">
        <label>' . $field->getLabel() . ': </label>
        <select  name="' . $field->getFormName() . '" ' . $field->getAttributesAsString() . '>';

    foreach ($field->getOptions() as $key => $value) {
        $selected = '';
        if ($key == $field->getValue()) {
            $selected = 'selected';
        }
        $select .= '<option value="' . $key . '" ' . $selected . ' >'
                    . $value
                    . '</option>';
    }

    $select .= '</select>
    </div>';

    return $select;
}

/**
 * vypise formularove pole pro radio
 *
 * @param RadioListField $field
 * @return string
 */
function getAdminRadioField(RadioListField $field, $size, $params = [])
{
    $separator = $params['separator'] . '';

    foreach ($field->getOptions() as $key => $value) {
        $ret[] = '<input ' .
                      ($key == $field->getValue() ? 'checked="checked"' : '') .
                      'value="' . $key . '" ' .
                      'id="radio--' . $key . '-' . $field->getFormName() . '" ' .
                      'name="' . $field->getFormName() . '" ' .
                      'type="radio" ' .
                      $field->getAttributesAsString() .
                    '>' .
                 '<label for="radio--' . $key . '-' . $field->getFormName() . '">' . $value . ': </label>';
    }

    return '<div class="form__item--' . $size . ' ">' . implode($separator, $ret) . '</div>' . LF;
}

/**
 * Vrati html kod formularoveho prvku
 *
 * @param \IZON\Forms\Form $form
 * @param string $fieldName nazev prvku
 * @param array $params pole s parametry<br>
 * $params['blockProp'] = css tridy, ktera se vaze na obalovaci blok<br>
 * $params['noWrapper'] = [bool] bez obalovaciho bloku<br>
 * @return string
 */
function getAdminField(\IZON\Forms\Form $form, $fieldName, $params = [])
{
    $field = $form->getField($fieldName);
    if ($field instanceof \IZON\Forms\Fields\HiddenField
        || array_key_exists('isHidden', $params) && $params['isHidden']) { // je hidden field
        $type = '\IZON\Forms\getHiddenField';
        $params['noWrapper'] = true;
    } if ($field instanceof \IZON\Forms\Fields\IdField) { // je hidden field
        $type = '\IZON\Forms\getIdField';
        $params['noWrapper'] = true;
    } else {
        $refClass = new \ReflectionClass($field);
        $type = '\IZON\Forms\get' . $refClass->getShortName();
    }
    //echo $type.'<br>';
    if (!function_exists($type)) {
        throw new \Exception('Pro zadany typ pole (' . $type . ') neexistuje renderovaci fce.');
    }

    $ret = call_user_func_array($type, [$field, $params]);
    if ($params['noWrapper'] ?? false) {
        return $ret;
    }
    if (empty(trim($params['blockProp']))) {
        $params['blockProp'] = 100;
    }
    return '<div class="form__item--' . $params['blockProp'] . ($field->hasErrors() ? ' error' : '') . '">' . $ret . '</div>' . LF;
}
