<?php

/*
 * pomocne funkce pro zobrazovani informaci v adminu
 */

namespace AdminPHPView;

use IZON\Admin\Config;
use IZON\MVC\View\PHPView;

/**
 *
 * @param string $moduleControllerId jaky controller volat
 * @param string $action jakou akci controlleru volat
 * @param array $params dalsi parametry, ktere predavat
 * @param string $moduleIdentifier jaky modul volat
 * @return string url pomoci ktereho se zavola dany controller
 *
 * TODO: vyresit, aby se nemuselo zadavat $moduleIdentifier pro odkaz do stejneho modulu
 */
function getModuleActionURL(
    $moduleControllerId,
    $action,
    $params = [],
    $moduleIdentifier = null
) {
    $controllerId = Config::getModuleEntryName(
        $moduleControllerId,
        $moduleIdentifier
    );
    $params["action"] = $action;
    
    $view = PHPView::getApplicationView();
    $locale = $view->getLocale();
    return $view->getRouter()->findURL($controllerId, $params, null, $locale);
}
