<?php

namespace IZON\Admin\MVC\Views\Resolvers;

use IZON\Admin\MVC\Views\AdminPHPView;
use IZON\Logs\Logger;

use IZON\MVC\View\Resolvers\ViewResolver;

/**
 * trida dohledavajici ktere view se ma pouzit
 *
 * admin pohledy musi zacinat cestou admin/ aby byly zpracovany timto Resolverem
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package IZON\MVC
 */
class AdminPHPViewResolver implements ViewResolver
{
    /**
     * @var string view admina
     */
    protected $adminViewsDir = "/vendor/izon/admin/views";
    
    /**
     * @var string view specificke pro admin
     */
    protected $specificViewsDir = "/app/views";
    
    /**
     * v jakych adresarich se nachazeji view modulu
     * @var array
     */
    protected $viewsDirs = null;
    
    
    /**
     * konfigurace nacitanych view
     * @var array
     */
    protected $viewsConfig = [];
    
    /**
     *
     * @var Logger
     */
    protected $log = null;
    
    public function __construct(array $viewsConfig = [])
    {
        $this->log = Logger::getLogger(self::class);
                
        $this->viewsConfig = $viewsConfig;
        
        $dirs = \IZON\Admin\Config::getModulesDirs();
        $this->viewsDirs = [];
        foreach ($dirs as $key => $dir) {
            $this->viewsDirs[$key] = $dir . "/views";
        }
    }

    public function buildView($viewName)
    {
        if (!\IZON\String\startsWith($viewName, "admin/")) {
            $this->log->info(self::class . " not handling view " . $viewName . " it doesn't contain admin/ prefix");
            return null;
        }
        
        $this->log->info("bulding view with name " . $viewName);
        
        // hleda prepisovatelne casti view z app/views
        $viewFile = __BASE_DIR__ . $this->specificViewsDir . "/" . $viewName . AdminPHPView::VIEW_SUFFIX;
        if (file_exists($viewFile)
            && is_file($viewFile)) {
            $this->log->info("View $viewName found in app/views.");
            
            return new AdminPHPView($viewName, $viewFile);
        }
        
        // vytahnout informace o modulu z viewName
        if (preg_match("#^admin/([a-zA-Z0-9\-]+/[a-zA-Z0-9\-]+)/.*$#", $viewName, $matches)) {
            $moduleType = $matches[1]; // typ modulu ve kterem se ma hledat

            if (isset($this->viewsDirs[$moduleType])) {
                $moduleDir = $this->viewsDirs[$moduleType];
                
                // nove kratsi cesty
                $viewFile = $moduleDir . str_replace("admin/" . $moduleType, "", $viewName) . AdminPHPView::VIEW_SUFFIX;
                if (file_exists($viewFile)
                    && is_file($viewFile)) {
                    $this->log->info("View $viewName found in module $moduleType");
                    
                    return new AdminPHPView($viewName, $viewFile);
                }
            }
        }
        
        $viewFile = __BASE_DIR__ . $this->adminViewsDir . "/" . $viewName . AdminPHPView::VIEW_SUFFIX;
        if (file_exists($viewFile)
            && is_file($viewFile)) {
            $this->log->info("View $viewName found in vendor/izon/admin");
            
            return new AdminPHPView($viewName, $viewFile);
        }
        
        $this->log->info("View not found, Pass to next resolver");
        
        return null;
    }
}
