<?php

namespace IZON\Admin\MVC\Views\Resolvers;

use Exception;

use IZON\Admin\MVC\Views\AdminPHPLayoutView;
use IZON\Logs\Logger;

use IZON\MVC\View\Resolvers\ViewResolver;

/**
 * trida dohledavajici ktere view se ma pouzit
 *
 * admin pohledy musi zacinat cestou admin/ aby byly zpracovany timto Resolverem
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package IZON\MVC
 */
class AdminPHPLayoutViewResolver implements ViewResolver
{
    /**
     * @var string view admina
     */
    protected $adminViewsDir = "/vendor/izon/admin/views";

    /**
     * @var string view specificke pro admin
     */
    protected $specificViewsDir = "/app/views";

    /**
     * v jakych adresarich se nachazeji view modulu
     * @var array
     */
    protected $viewsDirs = null;


    /**
     * TODO: vyresit nejak univerzalneji
     * @var string layouts for admin
     */
    protected $adminLayoutsDir = "/vendor/izon/admin/layouts";

    /**
     * suffix of template part file
     */
    protected $templatePartSuffix = ".tmpl.php";

    /**
     * suffix of layout file
     */
    protected $layoutSuffix = ".lay.php";


    /**
     * konfigurace nacitanych view
     * @var array
     */
    protected $viewsConfig = [];

    /**
     *
     * @var Logger
     */
    protected $log = null;

    public function __construct(array $viewsConfig)
    {
        $this->log = Logger::getLogger(self::class);

        if (!isset($viewsConfig["_default"]["layout"])) {
            throw new Exception('V poli musi byt nastaven defaultni layout (\$viewsConfig["_default"]["layout"])');
        }

        $this->viewsConfig = $viewsConfig;

        $dirs = \IZON\Admin\Config::getModulesDirs();
        $this->viewsDirs = [];
        foreach ($dirs as $key => $dir) {
            $this->viewsDirs[$key] = $dir . "/views";
        }
    }

    public function buildView($viewName)
    {
        if (!\IZON\String\startsWith($viewName, "admin/")) {
            $this->log->info(self::class . " not handling view " . $viewName . " it doesn't contain admin/ prefix");
            return null;
        }

        $this->log->info("bulding view with name " . $viewName);

        $layoutFileName = $this->viewsConfig[$viewName]["layout"] ?? null;
        if ($layoutFileName == null) { // neni zmeneno nastavit defaultni
            $layoutFileName = $this->viewsConfig["_default"]["layout"];
        }
        // which file to use for rendering
        $layoutFileName = __BASE_DIR__ . $this->adminLayoutsDir . "/" . $layoutFileName . $this->layoutSuffix;
        $this->log->info("Using layout $layoutFileName");

        // test jestli layout existuje
        if (!file_exists($layoutFileName)) {
            $message = "File $layoutFileName doesn't exist";
            $e = new Exception($message);
            $this->log->error($message, ['exception' => $e]);
            throw $e;
        }

        // ve kterych adresarich byly nalezeny casti view
        $foundViewDirs = [];

        // hleda prepisovatelne casti view
        $viewDir = __BASE_DIR__ . $this->specificViewsDir . "/" . $viewName;
        if (file_exists($viewDir)
            && is_dir($viewDir)) {
            $foundViewDirs[__BASE_DIR__ . $this->specificViewsDir] = $viewName;
        }

        // vytahnout informace o modulu z viewName
        if (preg_match("#^admin/([a-zA-Z0-9\-]+/[a-zA-Z0-9\-]+)/.*$#", $viewName, $matches)) {
            $moduleType = $matches[1]; // typ modulu ve kterem se ma hledat

            if (isset($this->viewsDirs[$moduleType])) {
                $moduleDir = $this->viewsDirs[$moduleType];

                // nove kratsi cesty
                $viewDir = $moduleDir . str_replace("admin/" . $moduleType, "", $viewName);
                if (file_exists($viewDir)
                    && is_dir($viewDir)) {
                    $foundViewDirs[$moduleDir] = str_replace("admin/" . $moduleType . "/", "", $viewName);
                }

                // pro spetnou kompatibilitu
                $viewDir = $moduleDir . "/" . $viewName;
                if (file_exists($viewDir)
                    && is_dir($viewDir)) {
                    $foundViewDirs[$moduleDir] = $viewName;
                }
            }
        }

        // view jen pro admin
        $foundViewDirs[__BASE_DIR__ . $this->adminViewsDir] = $viewName;

        // no dir for the view
        if (\IZON\Arrays\isEmpty($foundViewDirs)) {
            throw new Exception("View $viewName doesn't have tempaltes.");
        }

        $this->log->info("Found view dir " . $viewDir);

        // create view
        $view = new AdminPHPLayoutView(
            $layoutFileName,
            $viewName,
            $foundViewDirs
        );
        return $view;
    }
}
