<?php

namespace IZON\Admin\MVC\Views;

use IZON\Logs\Logger;

use IZON\MVC\View\PHPView;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
class AdminPHPView extends PHPView
{
    /**
     * suffix of view file
     */
    public const VIEW_SUFFIX = ".tmpl.php";

    /**
     *
     * @var cesta ke view, ktere se ma pouzit
     */
    protected $viewPath;


    /**
     * logger pro tridu
     * @var Logger
     */
    protected $log;
    
    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    public function __construct($viewName, $viewPath)
    {
        parent::__construct($viewName);
        $this->viewPath = $viewPath;
        
        // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }

    /**
     * provede vykresleni celeho view
     */
    public function render()
    {
        require_once $this->viewPath;
    }
}
