<?php

namespace IZON\Admin\MVC\Views;

use Exception;

use IZON\Logs\Logger;

use IZON\MVC\View\PHPView;

/**
 * trida renderujici view, resici cachovani rendrovani view, skladajici view
 * z jednotlivych casti, ...
 * jednotliva view jsou ulozena v adresarich
 * pri devel modu naincluduje nekde dole ve strance misto na debug informace
 *
 * @author David Dryml <dryml@izon.cz>
 * @copyright Copyright 2009, HI Software s.r.o.
 *
 * @version v1.0 rc
 *
 * @package MVC
 */
class AdminPHPLayoutView extends PHPView
{
    /**
     * suffix of template part file
     */
    public const PART_SUFFIX = ".tmpl.php";
    
    /**
     * suffix of layout file
     */
    public const LAYOUT_SUFFIX = ".lay.php";

    /**
     * name of layout to use
     * @var string
     */
    private $layoutName;

    /**
     * cesty k adresari s views pro jednotlive moduly
     * @var array
     */
    protected $modulesPaths;


    /**
     * logger pro tridu
     * @var Logger
     */
    protected $log;
    
    /**
     * vytvari view podle zadaneho jmena a predava mu parametry
     */
    public function __construct($layoutName, $viewName, array $modulesPaths)
    {
        parent::__construct($viewName);
        // TODO test na existenci layoutu a adresare s view
        $this->layoutName = $layoutName;
        
        $this->modulesPaths = $modulesPaths;
        
        // logovani
        $this->log = Logger::getLogger(__CLASS__);
    }

    public function getLayoutName()
    {
        return $this->layoutName;
    }

    /**
     * provede vykresleni celeho view
     */
    public function render()
    {
        require_once $this->layoutName;
    }

    /**
     * provede renderovani soucasti graficleho rozhrani
     */
    public function renderLayoutPart($partName)
    {
        $partFilePath = $this->findLayoutPartFilePath($partName);
        // TODO tady bude test jestli se vubec nejaky soubor nacel
        require_once $partFilePath;
    }

    /**
     * najde cestu k potrebne casti grafickeho rozhrani
     */
    protected function findLayoutPartFilePath($partName)
    {
        $this->log->info("Calling findLayoutPartFilePath with parameter: [$partName]");
        // search all modules tempalte parhs for parts
        foreach ($this->modulesPaths as $modulePath => $shordedViewName) {
            $templatePartFolder = $modulePath . "/" . $shordedViewName;
            
            // try language specific file
            $templatePartFile = $templatePartFolder . "/" . $partName . "." . $this->getLang() . self::PART_SUFFIX;
            $this->log->info("Trying template $templatePartFile");
            if (file_exists($templatePartFile)
                && is_file($templatePartFile)) {
                $this->log->info("Found template $templatePartFile");
                return $templatePartFile;
            }
            
            // try language nonspecific file
            $templatePartFile = $templatePartFolder . "/" . $partName . self::PART_SUFFIX;
            $this->log->info("Trying template $templatePartFile");
            if (file_exists($templatePartFile)
                && is_file($templatePartFile)) {
                $this->log->info("Found template $templatePartFile");
                return $templatePartFile;
            }
            
            // zkusit projit stromem ke koreni
            $dirsArray = explode("/", $shordedViewName);
            for ($i = count($dirsArray) - 1; $i >= 0; $i--) {
                $dir = $this->createSubdir($dirsArray, $i);
                
                $templatePartFile = $modulePath . "/" . $dir . "/" . $partName . "." . $this->getLang() . self::PART_SUFFIX;
                $this->log->info("Trying template $templatePartFile");
                if (file_exists($templatePartFile)
                    && is_file($templatePartFile)) {
                    $this->log->info("Found template $templatePartFile");
                    return $templatePartFile;
                }

                // try language nonspecific file
                $templatePartFile = $modulePath . "/" . $dir . "/" . $partName . self::PART_SUFFIX;
                if (file_exists($templatePartFile)
                    && is_file($templatePartFile)) {
                    $this->log->info("Found template $templatePartFile");
                    return $templatePartFile;
                }
            }
        }
        
        throw new Exception("mrtva vetev");
    }

    /**
     * vytvoti cestu k podadresari podle polozek v poli a poctu polozek, ktere se maji\
     * pozit
     */
    private function createSubdir($subdirsArray, $count)
    {
        return implode('/', array_slice($subdirsArray, 0, $count));
    }

    // TODO: vracet to co se nastavi ve viewResolveru
    private function findLayoutFilePath()
    {
        return "app/layouts/" . $this->layoutName . self::LAYOUT_SUFFIX;
    }
}
