<?php

namespace IZON\Admin\MVC\Context;

use IZON\Admin\MVC\ModuleInfo;

use IZON\MVC\Context\Context;

use IZON\MVC\HttpSession;

/**
 * context specific info for admin
 * contains ModuleInfo of current module, ...
 *
 * @author IZON s.r.o. <info@izon.cz>
 * @copyright Copyright 2017, IZON s.r.o.
 *
 * @package IZON\Admin\MVC\Context
 */
class AdminContext extends Context
{
    /**
     * @var ModuleInfo
     */
    protected $moduleInfo;
    
    
    /// generated constructor
    public function __construct(HttpSession $session, ModuleInfo $moduleInfo)
    {
        parent::__construct($session);
        $this->moduleInfo = $moduleInfo;
    }
    

    /// generated getter and setters
    public function getModuleInfo()
    {
        return $this->moduleInfo;
    }

    public function setModuleInfo(ModuleInfo $moduleInfo)
    {
        $this->moduleInfo = $moduleInfo;
    }

    public function getContextId()
    {
        return "admin";
    }
}
