<?php

namespace IZON\Admin\Domain;

use IZON\DB\DBObject;

/**
 * nejaka ztavba na kterou se ma odkazovar
 */
class AdminRole implements DBObject
{
    /**
     * nazev tabulky na kterou se mapuje
     */
    public static function __tableName()
    {
        return 'core_admin_roles';
    }
    
    /**
     * @var integer
     */
    protected $id;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $description;

    /**
     * @var AdminModule[]
     */
    protected $modules = [];
    public static function __modules()
    {
        return \IZON\DB\transientField();
    }
    
    
    /// generated getters and setters
    public function getId()
    {
        return $this->id;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getDescription()
    {
        return $this->description;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function setDescription($description)
    {
        $this->description = $description;
    }
    
    public function getModules()
    {
        return $this->modules;
    }

    public function setModules(array $modules)
    {
        $this->modules = $modules;
    }
}
