<?php

namespace IZON\Admin\Domain;

use IZON\DB\DBObject;

/**
 * nejaka ztavba na kterou se ma odkazovar
 */
class AdminModule implements DBObject
{
    /**
     *
     * @var integer
     */
    protected $id;
    //    public static function __id() { return "blah3333"; }

    /**
     * typ modulu
     * @var string
     */
    protected $type;

    /**
     * unikatni identifikator daneh modulu
     * @var string
     */
    protected $identifier;

    /**
     *
     * @var string
     */
    protected $name;
    //    public static function __name() { return IZON\DB\charField(['maxLength' => 255]); }

    /**
     * @var boolean
     */
    protected $enabled;

    /**
     * urcuje, jestli se ma zobrazovat v adminu
     * @var boolean
     */
    protected $adminVisible;

    /**
     * jak se maji moduly seradit
     * @var integer
     */
    protected $moduleOrder;
    
    /**
     * ikona modulu
     * @var string
     */
    protected $icon;
    
    
    public function getId()
    {
        return $this->id;
    }

    public function getType()
    {
        return $this->type;
    }

    public function getIdentifier()
    {
        return $this->identifier;
    }

    public function getName()
    {
        return $this->name;
    }

    public function getEnabled()
    {
        return $this->enabled;
    }

    public function getModuleOrder()
    {
        return $this->moduleOrder;
    }

    public function setId($id)
    {
        $this->id = $id;
    }

    public function setType($type)
    {
        $this->type = $type;
    }

    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;
    }

    public function setName($name)
    {
        $this->name = $name;
    }

    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    public function setModuleOrder($moduleOrder)
    {
        $this->moduleOrder = $moduleOrder;
    }
    
    public function getIcon()
    {
        return $this->icon;
    }

    public function setIcon($icon)
    {
        $this->icon = $icon;
    }
}
