<?php

namespace IZON\Admin\Dao;

use IZON\Admin\Domain\AdminModule;
use IZON\DB\Dao;

use IZON\DB\QueryResult;

interface AdminModuleDao extends Dao
{
    /**
     * pro jakou tridu se toto dao pouziva
     */
    public const DOMAIN_CLASS = AdminModule::class;

    /**
     * Vraci vsechny aktivni moduly
     * @return QueryResult
     */
    public function findActiveModules();
    
    /**
     * Vraci vsechny v adminu viditelne moduly
     * @return QueryResult
     */
    public function findAdminVisibleModules();
    
    
    /**
     * Vraci vsechny aktivni konstrukce
     * @return QueryResult
     */
    public function findUserAdminVisibleModules($userId);
}
