<?php

/**
 * funkce pouzivane pri konfiguraci Dependency Injectin
 */

namespace IZON\Admin\DI;

use IZON\Admin\Config;
use IZON\Admin\DI\Definition\Helper\ModuleConfigDefinitionHelper;
use function IZON\DI\get;

if (!function_exists('IZON\Admin\DI\moduleConfig')) {
    /**
     * nacita informace z nastaveni modulu v db
     * @param string $moduleConfigName nazev konfigurace co se ma vytahnout z konfigurace modulu
     * @return ModuleConfigDefinitionHelper
     */
    function moduleConfig($moduleConfigName)
    {
        // TODO: je celkem ochcavka, udelat lip
        $moduleIdentifier = Config::$moduleIdentifier;
        return new ModuleConfigDefinitionHelper(
            $moduleIdentifier,
            $moduleConfigName
        );
    }
}

if (!function_exists('IZON\Admin\DI\moduleGet')) {
    /**
     * Provede načtení hodnoty z modulu
     * podobné jako IZON\DI\get
     *
     * @param string $entryName nazev polozky co se ma vytahnout
     * @param string $moduleIdentifier indentifier modulu, z kereho se maji data vytahnout
     *
     * @return EntryReference
     */
    function moduleGet(
        $entryName,
        $moduleIdentifier = null
    ) {
        $completeEntryName = Config::getModuleEntryName(
            $entryName,
            $moduleIdentifier
        );
        return get($completeEntryName);
    }
}

if (!function_exists('IZON\Admin\DI\moduleIdentifier')) {
    /**
     * vrati identifier z nejakeho modulu
     * podobné jako IZON\DI\get
     *
     * @param string $entryName nazev polozky co se ma vytahnout
     * @param string $moduleIdentifier indentifier modulu, z kereho se maji data vytahnout
     *
     * @return EntryReference
     */
    function moduleIdentifier(
        $entryName,
        $moduleIdentifier = null
    ) {
        $completeEntryName = Config::getModuleEntryName(
            $entryName,
            $moduleIdentifier
        );
        return $completeEntryName;
    }
}
